/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import jnr.ffi.Address;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.byref.ByReference;
import jnr.ffi.provider.InvocationSession;
import jnr.ffi.provider.jffi.AsmLibraryLoader;
import jnr.ffi.provider.jffi.AsmRuntime;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BaseMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.Signature;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;

final class BufferMethodGenerator
extends BaseMethodGenerator {
    BufferMethodGenerator() {
    }

    public void generate(SkinnyMethodAdapter mv, Signature signature) {
        BufferMethodGenerator.generateBufferInvocation(mv, signature.resultType, signature.resultAnnotations, signature.parameterTypes, signature.parameterAnnotations);
    }

    public boolean isSupported(Signature signature) {
        return true;
    }

    static final void emitInvocationBufferNumericParameter(SkinnyMethodAdapter mv, Class parameterType, Annotation[] parameterAnnotations) {
        String paramMethod = null;
        Class<Number> nativeParamType = Integer.TYPE;
        if (Byte.TYPE == parameterType || Byte.class == parameterType) {
            paramMethod = "putByte";
        } else if (Short.TYPE == parameterType || Short.class == parameterType) {
            paramMethod = "putShort";
        } else if (Integer.TYPE == parameterType || Integer.class == parameterType || Boolean.TYPE == parameterType || Boolean.class == parameterType) {
            paramMethod = "putInt";
        } else if (NumberUtil.isLong32(parameterType, parameterAnnotations)) {
            paramMethod = "putInt";
            nativeParamType = Integer.TYPE;
        } else if (NumberUtil.isLong64(parameterType, parameterAnnotations)) {
            paramMethod = "putLong";
            nativeParamType = Long.TYPE;
        } else if (Float.TYPE == parameterType || Float.class == parameterType) {
            paramMethod = "putFloat";
            nativeParamType = Float.TYPE;
        } else if (Double.TYPE == parameterType || Double.class == parameterType) {
            paramMethod = "putDouble";
            nativeParamType = Double.TYPE;
        } else {
            throw new IllegalArgumentException("unsupported parameter type " + parameterType);
        }
        if (!parameterType.isPrimitive()) {
            AsmUtil.unboxNumber(mv, parameterType, nativeParamType);
        }
        mv.invokevirtual(HeapInvocationBuffer.class, paramMethod, Void.TYPE, nativeParamType);
    }

    static boolean isSessionRequired(Class parameterType, Annotation[] annotations) {
        return StringBuilder.class.isAssignableFrom(parameterType) || StringBuffer.class.isAssignableFrom(parameterType) || ByReference.class.isAssignableFrom(parameterType) || parameterType.isArray() && Pointer.class.isAssignableFrom(parameterType.getComponentType()) || parameterType.isArray() && CharSequence.class.isAssignableFrom(parameterType.getComponentType()) || parameterType.isArray() && NativeLong.class.isAssignableFrom(parameterType.getComponentType()) || parameterType.isArray() && NumberUtil.isLong32(parameterType.getComponentType(), annotations);
    }

    static boolean isSessionRequired(Class[] parameterTypes, Annotation[][] annotations) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!BufferMethodGenerator.isSessionRequired(parameterTypes[i], annotations[i])) continue;
            return true;
        }
        return false;
    }

    static final void marshal(SkinnyMethodAdapter mv, Class ... parameterTypes) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), "marshal", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(InvocationBuffer.class), parameterTypes));
    }

    static final void sessionmarshal(SkinnyMethodAdapter mv, Class ... parameterTypes) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), "marshal", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(InvocationBuffer.class) + CodegenUtils.ci(InvocationSession.class), parameterTypes));
    }

    static final void generateBufferInvocation(SkinnyMethodAdapter mv, Class returnType, Annotation[] resultAnnotations, Class[] parameterTypes, Annotation[][] parameterAnnotations) {
        int lvarSession;
        boolean sessionRequired = BufferMethodGenerator.isSessionRequired(parameterTypes, parameterAnnotations);
        int n = lvarSession = sessionRequired ? AsmUtil.calculateLocalVariableSpace(parameterTypes) + 1 : -1;
        if (sessionRequired) {
            mv.newobj(CodegenUtils.p(InvocationSession.class));
            mv.dup();
            mv.invokespecial(InvocationSession.class, "<init>", Void.TYPE, new Class[0]);
            mv.astore(lvarSession);
        }
        mv.dup();
        mv.invokestatic(AsmRuntime.class, "newHeapInvocationBuffer", HeapInvocationBuffer.class, Function.class);
        int lvar = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            mv.dup();
            if (BufferMethodGenerator.isSessionRequired(parameterTypes[i], parameterAnnotations[i])) {
                mv.aload(lvarSession);
            }
            lvar = AsmLibraryLoader.loadParameter(mv, parameterTypes[i], lvar);
            int parameterFlags = AsmUtil.getParameterFlags(parameterAnnotations[i]);
            int nativeArrayFlags = AsmUtil.getNativeArrayFlags(parameterFlags) | ((parameterFlags & 2) != 0 ? 4 : 0);
            if (parameterTypes[i].isArray() && parameterTypes[i].getComponentType().isPrimitive()) {
                mv.pushInt(nativeArrayFlags);
                if (NumberUtil.isLong32(parameterTypes[i].getComponentType(), parameterAnnotations[i])) {
                    mv.invokestatic(CodegenUtils.p(AsmRuntime.class), "marshal32", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(InvocationBuffer.class) + CodegenUtils.ci(InvocationSession.class), parameterTypes[i], Integer.TYPE));
                    continue;
                }
                BufferMethodGenerator.marshal(mv, parameterTypes[i], Integer.TYPE);
                continue;
            }
            if (Pointer.class.isAssignableFrom(parameterTypes[i])) {
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.marshal(mv, Pointer.class, Integer.TYPE);
                continue;
            }
            if (Address.class.isAssignableFrom(parameterTypes[i])) {
                BufferMethodGenerator.marshal(mv, Address.class);
                continue;
            }
            if (Enum.class.isAssignableFrom(parameterTypes[i])) {
                BufferMethodGenerator.marshal(mv, Enum.class);
                continue;
            }
            if (Buffer.class.isAssignableFrom(parameterTypes[i])) {
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.marshal(mv, parameterTypes[i], Integer.TYPE);
                continue;
            }
            if (ByReference.class.isAssignableFrom(parameterTypes[i])) {
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.sessionmarshal(mv, ByReference.class, Integer.TYPE);
                continue;
            }
            if (StringBuilder.class.isAssignableFrom(parameterTypes[i]) || StringBuffer.class.isAssignableFrom(parameterTypes[i])) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.sessionmarshal(mv, parameterTypes[i], Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (CharSequence.class.isAssignableFrom(parameterTypes[i])) {
                BufferMethodGenerator.marshal(mv, CharSequence.class);
                continue;
            }
            if (parameterTypes[i].isArray() && CharSequence.class.isAssignableFrom(parameterTypes[i].getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.sessionmarshal(mv, CharSequence[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (Struct.class.isAssignableFrom(parameterTypes[i])) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.marshal(mv, Struct.class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (parameterTypes[i].isArray() && Struct.class.isAssignableFrom(parameterTypes[i].getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.marshal(mv, Struct[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (parameterTypes[i].isArray() && Pointer.class.isAssignableFrom(parameterTypes[i].getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                BufferMethodGenerator.sessionmarshal(mv, Pointer[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (parameterTypes[i].isPrimitive() || Number.class.isAssignableFrom(parameterTypes[i]) || Boolean.class == parameterTypes[i]) {
                BufferMethodGenerator.emitInvocationBufferNumericParameter(mv, parameterTypes[i], parameterAnnotations[i]);
                continue;
            }
            throw new IllegalArgumentException("unsupported parameter type " + parameterTypes[i]);
        }
        String invokeMethod = null;
        Class<Number> nativeReturnType = null;
        if (NumberUtil.isPrimitiveInt(returnType) || Void.TYPE == returnType || Byte.class == returnType || Short.class == returnType || Integer.class == returnType) {
            invokeMethod = "invokeInt";
            nativeReturnType = Integer.TYPE;
        } else if (NumberUtil.isLong32(returnType, resultAnnotations)) {
            invokeMethod = "invokeInt";
            nativeReturnType = Integer.TYPE;
        } else if (NumberUtil.isLong64(returnType, resultAnnotations)) {
            invokeMethod = "invokeLong";
            nativeReturnType = Long.TYPE;
        } else if (Pointer.class == returnType || Address.class == returnType || Struct.class.isAssignableFrom(returnType) || String.class.isAssignableFrom(returnType)) {
            invokeMethod = Platform.getPlatform().addressSize() == 32 ? "invokeInt" : "invokeLong";
            nativeReturnType = Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        } else if (Float.class == returnType || Float.TYPE == returnType) {
            invokeMethod = "invokeFloat";
            nativeReturnType = Float.TYPE;
        } else if (Double.class == returnType || Double.TYPE == returnType) {
            invokeMethod = "invokeDouble";
            nativeReturnType = Double.TYPE;
        } else {
            throw new IllegalArgumentException("unsupported return type " + returnType);
        }
        mv.invokevirtual(Invoker.class, invokeMethod, nativeReturnType, Function.class, HeapInvocationBuffer.class);
        if (sessionRequired) {
            mv.aload(lvarSession);
            mv.invokevirtual(CodegenUtils.p(InvocationSession.class), "finish", "()V");
        }
        AsmLibraryLoader.emitReturn(mv, returnType, nativeReturnType);
    }
}

