/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.constantine;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;

public class Platform {
    private static final Platform INSTANCE = new Platform();
    public static final Map<String, String> OS_NAMES = new HashMap<String, String>(){
        public static final long serialVersionUID = 1L;
        {
            this.put("Mac OS X", "darwin");
        }
    };
    public static final Map<String, String> ARCH_NAMES = new HashMap<String, String>(){
        public static final long serialVersionUID = 1L;
        {
            this.put("x86", "i386");
        }
    };
    public static final String ARCH = Platform.initArchitecture();
    public static final String OS = Platform.initOperatingSystem();
    public static final String NAME = String.format("%s-%s", ARCH, OS);
    public static final int BIG_ENDIAN = 4321;
    public static final int LITTLE_ENDIAN = 1234;
    public static final int BYTE_ORDER = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 4321 : 1234;

    public static Platform getPlatform() {
        return INSTANCE;
    }

    protected Platform() {
    }

    static String getConstantsPackageName() {
        Package pkg = Platform.class.getPackage();
        return pkg != null ? pkg.getName() : Platform.class.getName().substring(0, Platform.class.getName().lastIndexOf(46));
    }

    public String getPackageName() {
        return String.format("%s.platform.%s.%s", Platform.getConstantsPackageName(), OS, ARCH);
    }

    public String getOSPackageName() {
        return String.format("%s.platform.%s", Platform.getConstantsPackageName(), OS);
    }

    private static final String initOperatingSystem() {
        String osname = Platform.getProperty("os.name", "unknown").toLowerCase();
        for (String s : OS_NAMES.keySet()) {
            if (!s.equalsIgnoreCase(osname)) continue;
            return OS_NAMES.get(s);
        }
        if (osname.startsWith("windows")) {
            return "windows";
        }
        return osname;
    }

    private static final String initArchitecture() {
        String arch = Platform.getProperty("os.arch", "unknown").toLowerCase();
        for (String s : ARCH_NAMES.keySet()) {
            if (!s.equalsIgnoreCase(arch)) continue;
            return ARCH_NAMES.get(s);
        }
        return arch;
    }

    private static String getProperty(String property, String defValue) {
        try {
            return System.getProperty(property, defValue);
        }
        catch (SecurityException se) {
            return defValue;
        }
    }
}

