/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.pathing;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.plexus.util.DirectoryScanner;

public final class FileListBuilder {
    private static final Logger LOGGER = Logger.getLogger(FileListBuilder.class);

    private FileListBuilder() {
    }

    public static List<File> buildList(File root) {
        return FileListBuilder.buildFilteredList(root, null);
    }

    public static List<File> buildFilteredList(File root, String extension) {
        if (extension == null) {
            LOGGER.debug((Object)"building list with no extension filters...");
        } else {
            LOGGER.debug((Object)("building list with by extension filter \"" + extension + "\""));
        }
        List<File> fileList = null;
        if (root.exists()) {
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(root);
            String includes = "**/*";
            if (extension != null) {
                includes = includes + "." + extension;
            }
            ds.setIncludes(includes.split(" "));
            ds.setCaseSensitive(true);
            ds.scan();
            String[] relPaths = ds.getIncludedFiles();
            fileList = FileListBuilder.turnRelativeIntoFiles(root, relPaths);
        } else {
            fileList = new ArrayList<File>();
        }
        LOGGER.debug((Object)("fileList result:" + fileList));
        return fileList;
    }

    public static List<File> turnRelativeIntoFiles(File root, String[] relativePaths) {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < relativePaths.length; ++i) {
            File file = new File(root, relativePaths[i]);
            files.add(file);
        }
        return files;
    }
}

