/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.io;

import com.github.jlgrock.javascriptframework.mavenutils.io.DirectoryIO;
import com.github.jlgrock.javascriptframework.mavenutils.io.FileIO;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public final class ResourceIO {
    private static Logger logger = Logger.getLogger(ResourceIO.class);

    private ResourceIO() {
    }

    public static InputStream getResourceAsStream(String resourceLocation) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl.getResource(resourceLocation) == null) {
            throw new IOException("Resource at location \"" + resourceLocation + "\" doesn't exist");
        }
        BufferedInputStream is = new BufferedInputStream(cl.getResourceAsStream(resourceLocation));
        return is;
    }

    public static ZipInputStream getResourceAsZipStream(String resourceLocation) throws IOException {
        if (resourceLocation == null) {
            throw new IOException("resourceLocation cannot be null");
        }
        return new ZipInputStream(ResourceIO.getResourceAsStream(resourceLocation));
    }

    public static void copyResource(String pathToResource, File outputLocation) throws IOException {
        if (pathToResource == null) {
            throw new IOException("resourceStream cannot be null");
        }
        if (outputLocation == null) {
            throw new IOException("outputLocation cannot be null");
        }
        logger.debug((Object)("copying resource from resource \"" + pathToResource + "\" to \"" + outputLocation.getAbsoluteFile() + "\"."));
        try {
            InputStream resourceStream = ResourceIO.getResourceAsStream(pathToResource);
            DirectoryIO.createDir(outputLocation.getParentFile());
            FileIO.copyStream(resourceStream, new FileOutputStream(outputLocation));
        }
        catch (IOException ioe) {
            logger.error((Object)("There was a problem copying the resource from \"" + pathToResource + "\" to location \"" + outputLocation.getAbsolutePath() + "\""));
            throw ioe;
        }
    }
}

