/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.log4j.Logger;

public final class DirectoryIO {
    private static final Logger LOGGER = Logger.getLogger(DirectoryIO.class);

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        LOGGER.debug((Object)("Begin copy of source directory \"" + srcDir.getAbsolutePath() + "\" to destination \"" + destDir.getAbsoluteFile() + "\"."));
        if (!srcDir.exists()) {
            throw new IOException("Directory at location \"" + srcDir.getAbsolutePath() + "\" does not exist.");
        }
        IOFileFilter filter = FileFileFilter.FILE;
        filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{DirectoryFileFilter.DIRECTORY, filter});
        FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)filter);
    }

    public static void createDir(File dir) throws IOException {
        if (dir.isFile()) {
            throw new IOException("Cannot create directory because the following is a file: " + dir);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Can not create dir " + dir);
        }
    }

    public static void recursivelyDeleteDirectory(File dir) throws IOException {
        boolean noProblems;
        LOGGER.debug((Object)("starting delete of directory \"" + dir.getAbsoluteFile() + "\"."));
        if (!dir.exists()) {
            LOGGER.debug((Object)"deletion of directory ignored as it does not exist.");
            return;
        }
        if (!dir.isDirectory()) {
            throw new IOException("The path \"" + dir.getAbsolutePath() + "\" is not a valid directory and cannot be deleted.");
        }
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    DirectoryIO.recursivelyDeleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        if (!(noProblems = dir.delete())) {
            throw new IOException("There was a problem deleting the directory \"" + dir.getAbsolutePath() + "\"");
        }
    }

    private DirectoryIO() {
    }
}

