/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.io.timeandspace.cronscheduler;

import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OverwritingThreadFactory
implements ThreadFactory {
    private final ThreadFactory baseThreadFactory;
    @Nullable
    private final Integer priority;
    @Nullable
    final String name;

    OverwritingThreadFactory(ThreadFactory baseThreadFactory, @Nullable Integer priority, @Nullable String name) {
        this.baseThreadFactory = baseThreadFactory;
        this.priority = priority;
        this.name = name;
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        Thread t = this.baseThreadFactory.newThread(r);
        if (this.priority != null) {
            t.setPriority(this.priority);
        }
        if (this.name != null) {
            t.setName(this.name);
        }
        return t;
    }
}

