/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.impl.quarantine;

import java.io.File;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.Base64;
import org.repackage.com.github.jlangch.aviron.ex.HashException;

public class Hashes {
    public static String hashFile(String algorithm, String salt, File inputFile) {
        try {
            byte[] fileData = Files.readAllBytes(inputFile.toPath());
            return Hashes.hashData(algorithm, salt, fileData);
        }
        catch (Exception ex) {
            throw new HashException("Failed to compute hash for file!");
        }
    }

    public static String hashData(String algorithm, String salt, byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.reset();
            md.update(salt.getBytes("UTF-8"));
            md.update(data);
            return Hashes.encodeBase64(md.digest());
        }
        catch (Exception ex) {
            throw new HashException("Failed to compute hash for binary data!");
        }
    }

    public static boolean verifyFileHash(String algorithm, String salt, File inputFile, String hash) {
        try {
            byte[] fileData = Files.readAllBytes(inputFile.toPath());
            return Hashes.verifyDataHash(algorithm, salt, fileData, hash);
        }
        catch (Exception ex) {
            throw new HashException("Failed to compute hash for verification!");
        }
    }

    public static boolean verifyDataHash(String algorithm, String salt, byte[] fileData, String hash) {
        String fileDataHash = Hashes.hashData(algorithm, salt, fileData);
        return hash.equals(fileDataHash);
    }

    public static String encodeBase64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.getDecoder().decode(data);
    }
}

