/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.pdf;

import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.text.PDFTextStripperByArea;

public class PdfUrlExtractor {
    public static List<Url> extract(File pdf) {
        List<Url> list;
        RandomAccessReadBufferedFile raf = new RandomAccessReadBufferedFile(pdf);
        try {
            list = PdfUrlExtractor.extract(new PDFParser((RandomAccessRead)raf));
        }
        catch (Throwable throwable) {
            try {
                raf.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to extract URLs from PDF file", ex);
            }
        }
        raf.close();
        return list;
    }

    public static List<Url> extract(InputStream is) {
        try {
            return PdfUrlExtractor.extract(IOStreamUtil.copyIStoByteArray(is));
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to extract URLs from PDF input stream", ex);
        }
    }

    public static List<Url> extract(byte[] pdf) {
        try {
            return PdfUrlExtractor.extract(new PDFParser((RandomAccessRead)new RandomAccessReadBuffer(pdf)));
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to extract URLs from PDF byte buffer", ex);
        }
    }

    private static List<Url> extract(PDFParser pdfParser) throws Exception {
        try (PDDocument pdDocument = pdfParser.parse();){
            ArrayList<Url> urls = new ArrayList<Url>();
            int pageNum = 0;
            for (PDPage page : pdDocument.getPages()) {
                PDAnnotation annot;
                int j;
                ++pageNum;
                PDFTextStripperByArea stripper = new PDFTextStripperByArea();
                List annotations = page.getAnnotations();
                for (j = 0; j < annotations.size(); ++j) {
                    annot = (PDAnnotation)annotations.get(j);
                    if (!(annot instanceof PDAnnotationLink)) continue;
                    PDRectangle rect = annot.getRectangle();
                    float x = rect.getLowerLeftX();
                    float y = rect.getUpperRightY();
                    float width = rect.getWidth();
                    float height = rect.getHeight();
                    int rotation = page.getRotation();
                    if (rotation == 0) {
                        PDRectangle pageSize = page.getMediaBox();
                        y = pageSize.getHeight() - y;
                    }
                    Rectangle2D.Float awtRect = new Rectangle2D.Float(x, y, width, height);
                    stripper.addRegion(String.valueOf(j), (Rectangle2D)awtRect);
                }
                stripper.extractRegions(page);
                for (j = 0; j < annotations.size(); ++j) {
                    PDAnnotationLink link;
                    PDAction action;
                    annot = (PDAnnotation)annotations.get(j);
                    if (!(annot instanceof PDAnnotationLink) || !((action = (link = (PDAnnotationLink)annot).getAction()) instanceof PDActionURI)) continue;
                    PDActionURI uri = (PDActionURI)action;
                    String url = uri.getURI();
                    String urlText = stripper.getTextForRegion(String.valueOf(j));
                    urls.add(new Url(url, StringUtil.trimToEmpty(urlText), pageNum));
                }
            }
            ArrayList<Url> arrayList = urls;
            return arrayList;
        }
    }

    public static class Url {
        private final String url;
        private final String urlText;
        private final int pageNum;

        public Url(String url, String urlText, int pageNum) {
            this.url = url;
            this.urlText = urlText;
            this.pageNum = pageNum;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUrlText() {
            return this.urlText;
        }

        public int getPageNum() {
            return this.pageNum;
        }
    }
}

