/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.pdf;

import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import com.github.jlangch.venice.util.pdf.PdfLayoutTextStripper;
import java.io.File;
import java.io.InputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfTextStripper {
    public static String text(File pdf) {
        String string;
        RandomAccessReadBufferedFile raf = new RandomAccessReadBufferedFile(pdf);
        try {
            string = PdfTextStripper.text(new PDFParser((RandomAccessRead)raf));
        }
        catch (Throwable throwable) {
            try {
                raf.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to strip text from PDF file", ex);
            }
        }
        raf.close();
        return string;
    }

    public static String text(InputStream is) {
        try {
            return PdfTextStripper.text(IOStreamUtil.copyIStoByteArray(is));
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to strip text from PDF input stream", ex);
        }
    }

    public static String text(byte[] pdf) {
        try {
            return PdfTextStripper.text(new PDFParser((RandomAccessRead)new RandomAccessReadBuffer(pdf)));
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to strip text from PDF byte buffer", ex);
        }
    }

    private static String text(PDFParser pdfParser) throws Exception {
        try (PDDocument pdDocument = pdfParser.parse();){
            String string = new PdfLayoutTextStripper().getText(pdDocument);
            return string;
        }
    }
}

