/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.util.crypt.Encryptor_AES256_GCM;
import com.github.jlangch.venice.util.crypt.IEncryptor;
import com.github.jlangch.venice.util.dh.DiffieHellmanSharedSecret;
import java.util.Objects;

public class Encryptor {
    private final IEncryptor ecryptor;

    private Encryptor(IEncryptor ecryptor) {
        this.ecryptor = ecryptor;
    }

    public static Encryptor aes(DiffieHellmanSharedSecret secret) {
        Objects.requireNonNull(secret);
        try {
            return new Encryptor(Encryptor_AES256_GCM.create(secret.getSecretBase64()));
        }
        catch (Exception ex) {
            throw new VncException("Failed to createencryptor", ex);
        }
    }

    public static Encryptor off() {
        return new Encryptor(null);
    }

    public byte[] encrypt(byte[] data) {
        return this.encrypt(data, null, this.isActive());
    }

    public byte[] encrypt(byte[] data, byte[] aad) {
        return this.encrypt(data, aad, this.isActive());
    }

    public byte[] encrypt(byte[] data, byte[] aad, boolean encrypt) {
        Objects.requireNonNull(data);
        if (encrypt) {
            try {
                return this.ecryptor.encrypt(data, aad);
            }
            catch (Exception ex) {
                throw new VncException("Failed to encrypt message payload data", ex);
            }
        }
        return data;
    }

    public byte[] decrypt(byte[] data) {
        return this.decrypt(data, null, this.isActive());
    }

    public byte[] decrypt(byte[] data, boolean decrypt) {
        return this.decrypt(data, null, decrypt);
    }

    public byte[] decrypt(byte[] data, byte[] aad, boolean decrypt) {
        Objects.requireNonNull(data);
        if (decrypt) {
            try {
                return this.ecryptor.decrypt(data, aad);
            }
            catch (Exception ex) {
                throw new VncException("Failed to decrypt message payload data", ex);
            }
        }
        return data;
    }

    public boolean isActive() {
        return this.ecryptor != null;
    }
}

