/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl;

import com.github.jlangch.venice.util.ipc.IMessage;
import com.github.jlangch.venice.util.ipc.impl.Message;
import com.github.jlangch.venice.util.ipc.impl.Protocol;
import com.github.jlangch.venice.util.ipc.impl.util.Compressor;
import com.github.jlangch.venice.util.ipc.impl.util.Encryptor;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class TcpSubscriptionListener
implements Runnable {
    private final SocketChannel ch;
    private final Consumer<IMessage> handler;
    private final Compressor compressor;
    private final Encryptor encryptor;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public TcpSubscriptionListener(SocketChannel ch, Consumer<IMessage> handler, Compressor compressor, Encryptor encryptor) {
        Objects.requireNonNull(ch);
        Objects.requireNonNull(handler);
        Objects.requireNonNull(compressor);
        Objects.requireNonNull(encryptor);
        this.ch = ch;
        this.handler = handler;
        this.compressor = compressor;
        this.encryptor = encryptor;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void run() {
        try {
            try {
                this.running.set(true);
                while (true) {
                    Message msg;
                    if ((msg = Protocol.receiveMessage(this.ch, this.compressor, this.encryptor)) == null) {
                        continue;
                    }
                    try {
                        this.handler.accept(msg);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                this.running.set(false);
            }
        }
        catch (Throwable throwable) {
            this.running.set(false);
            throw throwable;
        }
    }
}

