/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.Excel;
import com.github.jlangch.venice.util.excel.ExcelFacade;
import com.github.jlangch.venice.util.pdf.HtmlColor;
import java.awt.Color;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ExcelCellStyleBuilder {
    private final ExcelFacade parentBuilder;
    private final Excel managedExcel;
    private final String id;
    private String format;
    private String fontRefName;
    private Short bgColorIndex;
    private Color bgColor;
    private Boolean wrapText;
    private HorizontalAlignment hAlign;
    private VerticalAlignment vAlign;
    private Short rotation;
    private BorderStyle borderTopStyle;
    private BorderStyle borderRightStyle;
    private BorderStyle borderBottomStyle;
    private BorderStyle borderLeftStyle;

    public ExcelCellStyleBuilder(ExcelFacade excelBuilder, Excel managedExcel, String id) {
        this.parentBuilder = excelBuilder;
        this.managedExcel = managedExcel;
        this.id = id;
    }

    public ExcelCellStyleBuilder format(String format) {
        this.format = format;
        return this;
    }

    public ExcelCellStyleBuilder font(String fontRefName) {
        this.fontRefName = fontRefName;
        return this;
    }

    public ExcelCellStyleBuilder bgColor(IndexedColors color) {
        this.bgColorIndex = color.getIndex();
        return this;
    }

    public ExcelCellStyleBuilder bgColor(Color color) {
        this.bgColor = color;
        return this;
    }

    public ExcelCellStyleBuilder bgColorHtml(String color) {
        this.bgColor = HtmlColor.getColor(color);
        return this;
    }

    public ExcelCellStyleBuilder bgColor(short bgColorIndex) {
        this.bgColorIndex = bgColorIndex;
        return this;
    }

    public ExcelCellStyleBuilder wrapText(boolean wrapText) {
        this.wrapText = wrapText;
        return this;
    }

    public ExcelCellStyleBuilder hAlign(HorizontalAlignment hAlign) {
        this.hAlign = hAlign;
        return this;
    }

    public ExcelCellStyleBuilder hAlignLeft() {
        this.hAlign = HorizontalAlignment.LEFT;
        return this;
    }

    public ExcelCellStyleBuilder hAlignCenter() {
        this.hAlign = HorizontalAlignment.CENTER;
        return this;
    }

    public ExcelCellStyleBuilder hAlignRight() {
        this.hAlign = HorizontalAlignment.RIGHT;
        return this;
    }

    public ExcelCellStyleBuilder vAlign(VerticalAlignment vAlign) {
        this.vAlign = vAlign;
        return this;
    }

    public ExcelCellStyleBuilder vAlignTop() {
        this.vAlign = VerticalAlignment.TOP;
        return this;
    }

    public ExcelCellStyleBuilder vAlignMiddle() {
        this.vAlign = VerticalAlignment.CENTER;
        return this;
    }

    public ExcelCellStyleBuilder vAlignBottom() {
        this.vAlign = VerticalAlignment.BOTTOM;
        return this;
    }

    public ExcelCellStyleBuilder rotation(short rotation) {
        this.rotation = rotation;
        return this;
    }

    public ExcelCellStyleBuilder borderTopStyle(BorderStyle style) {
        this.borderTopStyle = style;
        return this;
    }

    public ExcelCellStyleBuilder borderRightStyle(BorderStyle style) {
        this.borderRightStyle = style;
        return this;
    }

    public ExcelCellStyleBuilder borderBottomStyle(BorderStyle style) {
        this.borderBottomStyle = style;
        return this;
    }

    public ExcelCellStyleBuilder borderLeftStyle(BorderStyle style) {
        this.borderLeftStyle = style;
        return this;
    }

    public ExcelFacade end() {
        if (this.bgColorIndex != null) {
            this.managedExcel.registerCellFormat(this.id, this.format, this.fontRefName, this.bgColorIndex, this.wrapText, this.hAlign, this.vAlign, this.rotation, this.borderTopStyle, this.borderRightStyle, this.borderBottomStyle, this.borderLeftStyle);
        } else if (this.bgColor != null) {
            this.managedExcel.registerCellFormat(this.id, this.format, this.fontRefName, this.bgColor, this.wrapText, this.hAlign, this.vAlign, this.rotation, this.borderTopStyle, this.borderRightStyle, this.borderBottomStyle, this.borderLeftStyle);
        } else {
            this.managedExcel.registerCellFormat(this.id, this.format, this.fontRefName, (Short)null, this.wrapText, this.hAlign, this.vAlign, this.rotation, this.borderTopStyle, this.borderRightStyle, this.borderBottomStyle, this.borderLeftStyle);
        }
        return this.parentBuilder;
    }
}

