/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class Util {
    public static byte[] deriveKeyFromPassphrase(String passphrase, String secretKeyFactoryName, byte[] salt, int iterationCount, int keyLength) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), salt, iterationCount, keyLength);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(secretKeyFactoryName);
        return factory.generateSecret(spec).getEncoded();
    }

    public static Class<?> classForName(String name) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return Class.forName(name, true, contextClassLoader);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return Class.forName(name);
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Failed to load class '%s'", name), ex);
        }
    }

    public static boolean hasClass(String classname) {
        try {
            Class<?> clazz = Util.classForName(classname);
            return clazz != null;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

