/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import com.github.jlangch.venice.FileException;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.util.crypt.AbstractEncryptor;
import com.github.jlangch.venice.util.crypt.IEncryptor;
import com.github.jlangch.venice.util.crypt.Util;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class Encryptor_ChaCha20
extends AbstractEncryptor
implements IEncryptor {
    private static final boolean supported = Util.hasClass("javax.crypto.spec.ChaCha20ParameterSpec");
    private static ByteOrder ENDIAN = ByteOrder.BIG_ENDIAN;
    public static int KEY_ITERATIONS = 3000;
    public static int KEY_LEN = 256;
    private static int NONCE_LEN = 12;
    private static int COUNTER_LEN = 4;
    public static String SECRET_KEY_FACTORY = "PBKDF2WithHmacSHA256";
    private static byte[] KEY_SALT = new byte[]{69, 26, 121, 103, -70, -6, 13, 94, 3, 113, 68, 47, -61, -91, 110, 79};
    private final SecretKeySpec keySpec;

    private Encryptor_ChaCha20(SecretKeySpec keySpec) {
        Objects.requireNonNull(keySpec);
        this.keySpec = keySpec;
    }

    public static Encryptor_ChaCha20 create(String passphrase) throws GeneralSecurityException {
        Objects.requireNonNull(passphrase);
        return Encryptor_ChaCha20.create(passphrase, KEY_SALT, KEY_ITERATIONS);
    }

    public static Encryptor_ChaCha20 create(String passphrase, byte[] keySalt, Integer keyIterations) throws GeneralSecurityException {
        Objects.requireNonNull(passphrase);
        byte[] key = Util.deriveKeyFromPassphrase(passphrase, SECRET_KEY_FACTORY, keySalt == null ? KEY_SALT : keySalt, keyIterations == null ? KEY_ITERATIONS : keyIterations, KEY_LEN);
        return new Encryptor_ChaCha20(new SecretKeySpec(key, "ChaCha20"));
    }

    public static boolean isSupported() {
        return supported;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        Objects.requireNonNull(data);
        try {
            byte[] nonce = new byte[NONCE_LEN];
            new SecureRandom().nextBytes(nonce);
            int counter = new SecureRandom().nextInt();
            byte[] counterData = Encryptor_ChaCha20.counterToBytes(counter);
            AlgorithmParameterSpec param = Encryptor_ChaCha20.createChaCha20ParameterSpec(nonce, counter);
            Cipher cipher = Cipher.getInstance("ChaCha20");
            cipher.init(1, (Key)this.keySpec, param);
            byte[] encryptedData = cipher.doFinal(data);
            byte[] outData = new byte[NONCE_LEN + COUNTER_LEN + encryptedData.length];
            System.arraycopy(nonce, 0, outData, 0, nonce.length);
            System.arraycopy(counterData, 0, outData, NONCE_LEN, counterData.length);
            System.arraycopy(encryptedData, 0, outData, NONCE_LEN + COUNTER_LEN, encryptedData.length);
            return outData;
        }
        catch (Exception ex) {
            throw new FileException("Failed to decrypt data", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) {
        Objects.requireNonNull(data);
        try {
            byte[] nonce = new byte[NONCE_LEN];
            System.arraycopy(data, 0, nonce, 0, NONCE_LEN);
            byte[] counterBytes = new byte[COUNTER_LEN];
            System.arraycopy(data, NONCE_LEN, counterBytes, 0, COUNTER_LEN);
            int counter = Encryptor_ChaCha20.counterToInt(counterBytes);
            AlgorithmParameterSpec param = Encryptor_ChaCha20.createChaCha20ParameterSpec(nonce, counter);
            Cipher cipher = Cipher.getInstance("ChaCha20");
            cipher.init(2, (Key)this.keySpec, param);
            return cipher.doFinal(data, NONCE_LEN + COUNTER_LEN, data.length - NONCE_LEN - COUNTER_LEN);
        }
        catch (Exception ex) {
            throw new FileException("Failed to decrypt data", ex);
        }
    }

    public boolean hasProvider(String name) {
        return Security.getProvider(StringUtil.trimToEmpty(name)) != null;
    }

    private static byte[] counterToBytes(int counter) {
        return ByteBuffer.allocate(COUNTER_LEN).order(ENDIAN).putInt(counter).array();
    }

    private static int counterToInt(byte[] counter) {
        return ByteBuffer.wrap(counter).order(ENDIAN).getInt(0);
    }

    private static AlgorithmParameterSpec createChaCha20ParameterSpec(byte[] nonce, int counter) {
        try {
            Class<?> clazz = Util.classForName("javax.crypto.spec.ChaCha20ParameterSpec");
            Constructor<?> c = clazz.getConstructor(byte[].class, Integer.TYPE);
            return (AlgorithmParameterSpec)c.newInstance(nonce, counter);
        }
        catch (Exception ex) {
            throw new RuntimeException("Java Crypto algorithm ChaCha20 is not available!");
        }
    }
}

