/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ElapsedTime
implements Serializable {
    private final String name;
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicLong elapsedNanos = new AtomicLong(0L);
    private static final long serialVersionUID = -1L;

    public ElapsedTime(String name, long elapsedNanos) {
        this.name = name;
        this.count.set(1);
        this.elapsedNanos.set(elapsedNanos);
    }

    public ElapsedTime(String name, int count, long elapsedNanos) {
        this.name = name;
        this.count.set(count);
        this.elapsedNanos.set(elapsedNanos);
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count.get();
    }

    public long getElapsedNanos() {
        return this.elapsedNanos.get();
    }

    public ElapsedTime add(long elapsedNanos) {
        this.count.incrementAndGet();
        this.elapsedNanos.addAndGet(elapsedNanos);
        return this;
    }

    public String toString() {
        return String.format("%s [%d]: %s", this.name, this.count.get(), ElapsedTime.formatNanos(this.elapsedNanos.get()));
    }

    public static String formatNanos(long nanos) {
        if (nanos < 1000L) {
            return Long.valueOf(nanos).toString() + " ns";
        }
        if (nanos < 1000000L) {
            return String.format("%.2f us", (double)nanos / 1000.0);
        }
        if (nanos < 9000000000L) {
            return String.format("%.2f ms", (double)nanos / 1000000.0);
        }
        return String.format("%.2f s ", (double)nanos / 1.0E9);
    }
}

