/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ISODateTime {
    private static final DateTimeFormatter FMT_LOCAL_DATE = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter FMT_LOCAL_DATE_TIME = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private static final DateTimeFormatter FMT_ZONED_DATE_TIME = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    public static String formatISO(LocalDate date) {
        return date == null ? null : date.format(FMT_LOCAL_DATE);
    }

    public static String formatISO(LocalDateTime date) {
        return date == null ? null : date.format(FMT_LOCAL_DATE_TIME);
    }

    public static String formatISO(ZonedDateTime date) {
        return date == null ? null : date.format(FMT_ZONED_DATE_TIME);
    }

    public static LocalDate parseISO_LocalDate(String date) {
        return date == null ? null : LocalDate.parse(date, FMT_LOCAL_DATE);
    }

    public static LocalDateTime parseISO_LocalDateTime(String date) {
        return date == null ? null : LocalDateTime.parse(date, FMT_LOCAL_DATE_TIME);
    }

    public static ZonedDateTime parseISO_ZonedDateTime(String date) {
        return date == null ? null : ZonedDateTime.parse(date, FMT_ZONED_DATE_TIME);
    }
}

