/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncLazySeq;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.StreamUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VncTinyVector
extends VncVector {
    public static final VncTinyVector EMPTY = new VncTinyVector();
    public static final int MAX_ELEMENTS = 4;
    private static final long serialVersionUID = -1848883965231344442L;
    private final int len;
    private final VncVal first;
    private final VncVal second;
    private final VncVal third;
    private final VncVal fourth;

    public VncTinyVector() {
        this(null);
    }

    public VncTinyVector(VncVal meta) {
        super(meta);
        this.len = 0;
        this.first = Constants.Nil;
        this.second = Constants.Nil;
        this.third = Constants.Nil;
        this.fourth = Constants.Nil;
    }

    public VncTinyVector(VncTinyVector vec, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.len = vec.len;
        this.first = vec.first;
        this.second = vec.second;
        this.third = vec.third;
        this.fourth = vec.fourth;
    }

    private VncTinyVector(int len, VncVal first, VncVal second, VncVal third, VncVal fourth, VncVal meta) {
        super(meta);
        this.len = len;
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    public static VncTinyVector of(VncVal ... mvs) {
        switch (mvs.length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return new VncTinyVector(1, mvs[0], Constants.Nil, Constants.Nil, Constants.Nil, null);
            }
            case 2: {
                return new VncTinyVector(2, mvs[0], mvs[1], Constants.Nil, Constants.Nil, null);
            }
            case 3: {
                return new VncTinyVector(3, mvs[0], mvs[1], mvs[2], Constants.Nil, null);
            }
            case 4: {
                return new VncTinyVector(4, mvs[0], mvs[1], mvs[2], mvs[3], null);
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    public static VncTinyVector ofArr(VncVal[] mvs, VncVal meta) {
        switch (mvs.length) {
            case 0: {
                return new VncTinyVector(meta);
            }
            case 1: {
                return new VncTinyVector(1, mvs[0], Constants.Nil, Constants.Nil, Constants.Nil, meta);
            }
            case 2: {
                return new VncTinyVector(2, mvs[0], mvs[1], Constants.Nil, Constants.Nil, meta);
            }
            case 3: {
                return new VncTinyVector(3, mvs[0], mvs[1], mvs[2], Constants.Nil, meta);
            }
            case 4: {
                return new VncTinyVector(4, mvs[0], mvs[1], mvs[2], mvs[3], meta);
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVal apply(VncList args) {
        ArityExceptions.assertArity(this, ArityExceptions.FnType.Collection, args, 1, 2);
        if (args.size() == 1) {
            return this.nth(Coerce.toVncLong(args.first()).getValue().intValue());
        }
        return this.nthOrDefault(Coerce.toVncLong(args.first()).getValue().intValue(), args.second());
    }

    @Override
    public VncVector emptyWithMeta() {
        return new VncTinyVector(this.getMeta());
    }

    @Override
    public VncVector withValues(List<? extends VncVal> replaceVals) {
        return replaceVals.size() < 4 ? VncTinyVector.ofArr(replaceVals.toArray(new VncVal[0]), this.getMeta()) : VncVector.ofList(replaceVals, this.getMeta());
    }

    @Override
    public VncVector withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return replaceVals.size() < 4 ? VncTinyVector.ofArr(replaceVals.toArray(new VncVal[0]), meta) : VncVector.ofList(replaceVals, meta);
    }

    @Override
    public VncVector withMeta(VncVal meta) {
        return new VncTinyVector(this.len, this.first, this.second, this.third, this.fourth, meta);
    }

    @Override
    public VncVector wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncTinyVector(this, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return super.getType();
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : new MappingIterator(this);
    }

    @Override
    public Stream<VncVal> stream() {
        return StreamUtil.stream(this.iterator());
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.iterator().forEachRemaining(action);
    }

    @Override
    public VncVector filter(Predicate<? super VncVal> predicate) {
        VncVal[] values = new VncVal[this.len];
        int idx = 0;
        if (this.len > 0) {
            if (predicate.test(this.first)) {
                values[idx++] = this.first;
            }
            if (this.len > 1) {
                if (predicate.test(this.second)) {
                    values[idx++] = this.second;
                }
                if (this.len > 2) {
                    if (predicate.test(this.third)) {
                        values[idx++] = this.third;
                    }
                    if (this.len > 3 && predicate.test(this.fourth)) {
                        values[idx++] = this.fourth;
                    }
                }
            }
        }
        switch (idx) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return new VncTinyVector(1, values[0], Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(2, values[0], values[1], Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(3, values[0], values[1], values[2], Constants.Nil, this.getMeta());
            }
            case 4: {
                return new VncTinyVector(4, values[0], values[1], values[2], values[3], this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVector map(Function<? super VncVal, ? extends VncVal> mapper) {
        if (this.len == 0) {
            return EMPTY;
        }
        VncVal[] values = new VncVal[this.len];
        int idx = 0;
        values[idx++] = mapper.apply(this.first);
        if (this.len > 1) {
            values[idx++] = mapper.apply(this.second);
            if (this.len > 2) {
                values[idx++] = mapper.apply(this.third);
                if (this.len > 3) {
                    values[idx++] = mapper.apply(this.fourth);
                }
            }
        }
        return VncTinyVector.ofArr(values, this.getMeta());
    }

    @Override
    public List<VncVal> getJavaList() {
        ArrayList<VncVal> list = new ArrayList<VncVal>(this.len);
        if (this.len > 0) {
            list.add(this.first);
            if (this.len > 1) {
                list.add(this.second);
                if (this.len > 2) {
                    list.add(this.third);
                    if (this.len > 3) {
                        list.add(this.fourth);
                    }
                }
            }
        }
        return list;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.len) {
            throw new VncException(String.format("nth: index %d out of range for a vector of size %d.", idx, this.len));
        }
        switch (idx) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
            case 2: {
                return this.third;
            }
            case 3: {
                return this.fourth;
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        if (idx < 0 || idx >= this.len) {
            return defaultVal;
        }
        switch (idx) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
            case 2: {
                return this.third;
            }
            case 3: {
                return this.fourth;
            }
        }
        return defaultVal;
    }

    @Override
    public VncVal first() {
        return this.first;
    }

    @Override
    public VncVal second() {
        return this.second;
    }

    @Override
    public VncVal third() {
        return this.third;
    }

    @Override
    public VncVal fourth() {
        return this.fourth;
    }

    @Override
    public VncVal last() {
        switch (this.len) {
            case 0: {
                return Constants.Nil;
            }
            case 1: {
                return this.first;
            }
            case 2: {
                return this.second;
            }
            case 3: {
                return this.third;
            }
            case 4: {
                return this.fourth;
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVector rest() {
        switch (this.len) {
            case 0: {
                return this;
            }
            case 1: {
                return new VncTinyVector(this.getMeta());
            }
            case 2: {
                return new VncTinyVector(1, this.second, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(2, this.second, this.third, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 4: {
                return new VncTinyVector(3, this.second, this.third, this.fourth, Constants.Nil, this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVector butlast() {
        switch (this.len) {
            case 0: {
                return this;
            }
            case 1: {
                return new VncTinyVector(this.getMeta());
            }
            case 2: {
                return new VncTinyVector(1, this.first, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(2, this.first, this.second, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 4: {
                return new VncTinyVector(3, this.first, this.second, this.third, Constants.Nil, this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVector drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (n >= this.len) {
            return EMPTY;
        }
        switch (n) {
            case 1: {
                return new VncTinyVector(this.len - 1, this.second, this.third, this.fourth, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(this.len - 2, this.third, this.fourth, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(this.len - 3, this.fourth, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
        }
        return EMPTY;
    }

    @Override
    public VncVector dropWhile(Predicate<? super VncVal> predicate) {
        List<VncVal> list = this.getJavaList();
        for (int i = 0; i < list.size(); ++i) {
            boolean drop = predicate.test(list.get(i));
            if (drop) continue;
            return VncVector.ofList(list.subList(i, list.size()), this.getMeta());
        }
        return new VncTinyVector(this.getMeta());
    }

    @Override
    public VncVector dropRight(int n) {
        if (this.len == 0) {
            return this;
        }
        return n >= this.len ? this.emptyWithMeta() : this.slice(0, this.len - n);
    }

    @Override
    public VncVector take(int n) {
        if (n <= 0) {
            return EMPTY;
        }
        if (n >= this.len) {
            return this;
        }
        switch (n) {
            case 1: {
                return new VncTinyVector(1, this.first, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(2, this.first, this.second, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(3, this.first, this.second, this.third, Constants.Nil, this.getMeta());
            }
        }
        return this;
    }

    @Override
    public VncVector takeWhile(Predicate<? super VncVal> predicate) {
        List<VncVal> list = this.getJavaList();
        for (int i = 0; i < list.size(); ++i) {
            boolean take = predicate.test(list.get(i));
            if (take) continue;
            return VncVector.ofList(list.subList(0, i), this.getMeta());
        }
        return this;
    }

    @Override
    public VncVector takeRight(int n) {
        if (n >= this.len) {
            return this;
        }
        return n <= 0 ? this.emptyWithMeta() : this.slice(this.len - n);
    }

    @Override
    public VncVector reverse() {
        switch (this.len) {
            case 0: {
                return this;
            }
            case 1: {
                return this;
            }
            case 2: {
                return new VncTinyVector(2, this.second, this.first, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(3, this.third, this.second, this.first, Constants.Nil, this.getMeta());
            }
            case 4: {
                return new VncTinyVector(4, this.fourth, this.third, this.second, this.first, this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVector shuffle() {
        if (this.len <= 1) {
            return this;
        }
        List<VncVal> list = this.getJavaList();
        Collections.shuffle(list);
        return VncVector.ofList(list, this.getMeta());
    }

    @Override
    public VncVector distinct() {
        HashSet<VncVal> seen = new HashSet<VncVal>();
        VncVal[] values = new VncVal[this.len];
        int idx = 0;
        if (this.len > 0) {
            if (!seen.contains(this.first)) {
                values[idx++] = this.first;
                seen.add(this.first);
            }
            if (this.len > 1) {
                if (!seen.contains(this.second)) {
                    values[idx++] = this.second;
                    seen.add(this.second);
                }
                if (this.len > 2) {
                    if (!seen.contains(this.third)) {
                        values[idx++] = this.third;
                        seen.add(this.third);
                    }
                    if (this.len > 3 && !seen.contains(this.fourth)) {
                        values[idx++] = this.fourth;
                        seen.add(this.fourth);
                    }
                }
            }
        }
        switch (idx) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return new VncTinyVector(1, values[0], Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(2, values[0], values[1], Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(3, values[0], values[1], values[2], Constants.Nil, this.getMeta());
            }
            case 4: {
                return new VncTinyVector(4, values[0], values[1], values[2], values[3], this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVector slice(int start, int end) {
        if (start < 0) {
            throw new IllegalStateException("Vector index out of range");
        }
        if (start >= this.len || end <= start) {
            return EMPTY;
        }
        int len_ = Math.min(end, this.len) - start;
        VncVal[] vals = new VncVal[len_];
        for (int ii = 0; ii < len_; ++ii) {
            vals[ii] = this.nth(ii + start);
        }
        return VncTinyVector.ofArr(vals, this.getMeta());
    }

    @Override
    public VncVector slice(int start) {
        if (start <= 0) {
            return this;
        }
        if (start >= this.len) {
            return EMPTY;
        }
        switch (start) {
            case 1: {
                return new VncTinyVector(this.len - 1, this.second, this.third, this.fourth, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(this.len - 2, this.third, this.fourth, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(this.len - 3, this.fourth, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
        }
        return EMPTY;
    }

    @Override
    public VncVector toVncVector() {
        return this;
    }

    @Override
    public VncList toVncList() {
        switch (this.len) {
            case 0: {
                return new VncTinyList(this.getMeta());
            }
            case 1: {
                return VncTinyList.of(this.first).withMeta(this.getMeta());
            }
            case 2: {
                return VncTinyList.of(this.first, this.second).withMeta(this.getMeta());
            }
            case 3: {
                return VncTinyList.of(this.first, this.second, this.third).withMeta(this.getMeta());
            }
            case 4: {
                return VncTinyList.of(this.first, this.second, this.third, this.fourth).withMeta(this.getMeta());
            }
        }
        throw new IllegalStateException("Vector length out of range");
    }

    @Override
    public VncVector addAtStart(VncVal val) {
        switch (this.len) {
            case 0: {
                return new VncTinyVector(1, val, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 1: {
                return new VncTinyVector(2, val, this.first, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(3, val, this.first, this.second, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(4, val, this.first, this.second, this.third, this.getMeta());
            }
            case 4: {
                return VncVector.of(val, this.first, this.second, this.third, this.fourth).withMeta(this.getMeta());
            }
        }
        throw new IllegalStateException("Vector length out of range");
    }

    @Override
    public VncVector addAllAtStart(VncSequence list, boolean reverseAdd) {
        if (!(list instanceof VncLazySeq)) {
            int otherLen = list.size();
            if (otherLen == 0) {
                return this;
            }
            if (otherLen + this.len <= 4) {
                int ii;
                VncVal[] vals = new VncVal[otherLen + this.len];
                if (reverseAdd) {
                    for (ii = 0; ii < otherLen; ++ii) {
                        vals[ii] = list.nth(otherLen - ii - 1);
                    }
                } else {
                    for (ii = 0; ii < otherLen; ++ii) {
                        vals[ii] = list.nth(ii);
                    }
                }
                for (ii = 0; ii < this.len; ++ii) {
                    vals[ii + otherLen] = this.nth(ii);
                }
                return VncTinyVector.of(vals);
            }
        }
        VncSequence seq = reverseAdd ? list.reverse() : list;
        return VncVector.ofAll(seq, this.getMeta()).addAllAtEnd(this);
    }

    @Override
    public VncVector addAtEnd(VncVal val) {
        switch (this.len) {
            case 0: {
                return new VncTinyVector(1, val, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 1: {
                return new VncTinyVector(2, this.first, val, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(3, this.first, this.second, val, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(4, this.first, this.second, this.third, val, this.getMeta());
            }
            case 4: {
                return VncVector.of(this.first, this.second, this.third, this.fourth, val).withMeta(this.getMeta());
            }
        }
        throw new IllegalStateException("Vector length out of range");
    }

    @Override
    public VncVector addAllAtEnd(VncSequence list) {
        if (!(list instanceof VncLazySeq)) {
            int otherLen = list.size();
            if (otherLen == 0) {
                return this;
            }
            if (otherLen + this.len <= 4) {
                int ii;
                VncVal[] vals = new VncVal[otherLen + this.len];
                for (ii = 0; ii < this.len; ++ii) {
                    vals[ii] = this.nth(ii);
                }
                for (ii = 0; ii < otherLen; ++ii) {
                    vals[ii + this.len] = list.nth(ii);
                }
                return VncTinyVector.of(vals);
            }
        }
        return VncVector.ofAll(this, this.getMeta()).addAllAtEnd(list);
    }

    @Override
    public VncVector setAt(int idx, VncVal val) {
        if (idx < 0 || idx >= this.len) {
            throw new IllegalStateException("Vector index out of range");
        }
        switch (idx) {
            case 0: {
                return new VncTinyVector(this.len, val, this.second, this.third, this.fourth, this.getMeta());
            }
            case 1: {
                return new VncTinyVector(this.len, this.first, val, this.third, this.fourth, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(this.len, this.first, this.second, val, this.fourth, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(this.len, this.first, this.second, this.third, val, this.getMeta());
            }
        }
        throw new IllegalStateException("Vector length out of range");
    }

    @Override
    public VncVector removeAt(int idx) {
        if (idx < 0 || idx >= this.len) {
            throw new IllegalStateException("Vector index out of range");
        }
        if (this.len == 1) {
            return this.emptyWithMeta();
        }
        switch (idx) {
            case 0: {
                return new VncTinyVector(this.len - 1, this.second, this.third, this.fourth, Constants.Nil, this.getMeta());
            }
            case 1: {
                return new VncTinyVector(this.len - 1, this.first, this.third, this.fourth, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(this.len - 1, this.first, this.second, this.fourth, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(this.len - 1, this.first, this.second, this.third, Constants.Nil, this.getMeta());
            }
        }
        throw new IllegalStateException("Vector length out of range");
    }

    @Override
    public Object convertToJavaObject() {
        return this.stream().map((? super T v) -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncVector(o)) {
            int c = Integer.compare(this.size(), ((VncVector)o).size());
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < this.size(); ++ii) {
                c = this.nth(ii).compareTo(((VncVector)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.len;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        result = 31 * result + (this.third == null ? 0 : this.third.hashCode());
        result = 31 * result + (this.fourth == null ? 0 : this.fourth.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncTinyVector other = (VncTinyVector)obj;
        if (this.len != other.len) {
            return false;
        }
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        if (this.second == null ? other.second != null : !this.second.equals(other.second)) {
            return false;
        }
        if (this.third == null ? other.third != null : !this.third.equals(other.third)) {
            return false;
        }
        return !(this.fourth == null ? other.fourth != null : !this.fourth.equals(other.fourth));
    }

    @Override
    public String toString() {
        return "[" + Printer.join(this, " ", true) + "]";
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return "[" + Printer.join(this, " ", print_machine_readably) + "]";
    }

    private static class MappingIterator
    implements Iterator<VncVal> {
        private int index;
        private final VncTinyVector value;

        public MappingIterator(VncTinyVector value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.value.len;
        }

        @Override
        public VncVal next() {
            return this.value.nth(this.index++);
        }

        public String toString() {
            return "MappingIterator()";
        }
    }
}

