/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class VncSet
extends VncCollection
implements IVncFunction,
Iterable<VncVal> {
    public static final String TYPE = ":core/set";
    private static final long serialVersionUID = -1848883965231344442L;

    public VncSet(VncVal meta) {
        super(meta);
    }

    public VncSet(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
    }

    @Override
    public VncVal apply(VncList args) {
        ArityExceptions.assertArity(this, ArityExceptions.FnType.Collection, args, 1, 2);
        VncVal first = args.first();
        if (args.size() == 1) {
            return this.contains(first) ? first : Constants.Nil;
        }
        return this.contains(first) ? first : args.second();
    }

    @Override
    public VncList getArgLists() {
        return VncList.of(new VncString("(set val)"), new VncString("(set val default-val)"));
    }

    @Override
    public abstract VncSet emptyWithMeta();

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    public abstract VncSet withValues(Collection<? extends VncVal> var1);

    public abstract VncSet withValues(Collection<? extends VncVal> var1, VncVal var2);

    @Override
    public abstract VncSet withMeta(VncVal var1);

    public abstract VncSet add(VncVal var1);

    public abstract VncSet addAll(VncSet var1);

    public abstract VncSet addAll(VncSequence var1);

    public abstract VncSet remove(VncVal var1);

    public abstract VncSet removeAll(VncSet var1);

    public abstract VncSet removeAll(VncSequence var1);

    public abstract boolean contains(VncVal var1);

    public abstract Set<VncVal> getJavaSet();

    public abstract List<VncVal> getJavaList();

    @Override
    public abstract Iterator<VncVal> iterator();

    public abstract Stream<VncVal> stream();

    @Override
    public Object convertToJavaObject() {
        return this.stream().map(v -> v.convertToJavaObject()).collect(Collectors.toSet());
    }
}

