/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMutable;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class VncDeque
extends VncCollection
implements VncMutable,
Iterable<VncVal> {
    public static final String TYPE = ":core/deque";
    private static final long serialVersionUID = -564531670922145260L;
    private final int capacity;
    private final LinkedBlockingDeque<VncVal> deque;

    public VncDeque() {
        this(Integer.MAX_VALUE);
    }

    public VncDeque(int capacity) {
        super(Constants.Nil);
        this.capacity = capacity;
        this.deque = new LinkedBlockingDeque(capacity);
    }

    private VncDeque(VncDeque deque, VncVal meta) {
        super(meta);
        this.capacity = deque.capacity;
        this.deque = deque.deque;
    }

    @Override
    public VncCollection emptyWithMeta() {
        return new VncDeque(this.capacity);
    }

    @Override
    public VncDeque withMeta(VncVal meta) {
        return new VncDeque(this, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    @Override
    public VncList toVncList() {
        return VncList.of(this.deque.toArray(new VncVal[0]));
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.of(this.deque.toArray(new VncVal[0]));
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public VncBoolean offer(VncVal val) {
        return VncBoolean.of(this.deque.offer(val));
    }

    public VncBoolean offerFirst(VncVal val) {
        return VncBoolean.of(this.deque.offerFirst(val));
    }

    public VncBoolean offerLast(VncVal val) {
        return VncBoolean.of(this.deque.offerLast(val));
    }

    public VncBoolean offer(VncVal val, long timeoutMillis) {
        try {
            return VncBoolean.of(this.deque.offer(val, timeoutMillis, TimeUnit.MILLISECONDS));
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (offer! deque timeout val)", ex);
        }
    }

    public VncBoolean offerFirst(VncVal val, long timeoutMillis) {
        try {
            return VncBoolean.of(this.deque.offerFirst(val, timeoutMillis, TimeUnit.MILLISECONDS));
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (offer! deque timeout val)", ex);
        }
    }

    public VncBoolean offerLast(VncVal val, long timeoutMillis) {
        try {
            return VncBoolean.of(this.deque.offerLast(val, timeoutMillis, TimeUnit.MILLISECONDS));
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (offer! deque timeout val)", ex);
        }
    }

    public void put(VncVal val) {
        try {
            this.deque.put(val);
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (put! deque val)", ex);
        }
    }

    public void putFirst(VncVal val) {
        try {
            this.deque.putFirst(val);
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (put! deque val)", ex);
        }
    }

    public void putLast(VncVal val) {
        try {
            this.deque.putLast(val);
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (put! deque val)", ex);
        }
    }

    public VncVal poll() {
        return this.toNil(this.deque.poll());
    }

    public VncVal pollFirst() {
        return this.toNil(this.deque.pollFirst());
    }

    public VncVal pollLast() {
        return this.toNil(this.deque.pollLast());
    }

    public VncVal poll(long timeoutMillis) {
        try {
            return this.toNil(this.deque.poll(timeoutMillis, TimeUnit.MILLISECONDS));
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (poll! deque timeout)", ex);
        }
    }

    public VncVal pollFirst(long timeoutMillis) {
        try {
            return this.toNil(this.deque.pollFirst(timeoutMillis, TimeUnit.MILLISECONDS));
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (poll! deque timeout)", ex);
        }
    }

    public VncVal pollLast(long timeoutMillis) {
        try {
            return this.toNil(this.deque.pollLast(timeoutMillis, TimeUnit.MILLISECONDS));
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (poll! deque timeout)", ex);
        }
    }

    public VncVal peek() {
        return this.toNil(this.deque.peek());
    }

    public VncVal peekFirst() {
        return this.toNil(this.deque.peekFirst());
    }

    public VncVal peekLast() {
        return this.toNil(this.deque.peekLast());
    }

    public VncVal take() {
        try {
            return this.deque.take();
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (take! deque)", ex);
        }
    }

    public VncVal takeFirst() {
        try {
            return this.deque.takeFirst();
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (take! deque)", ex);
        }
    }

    public VncVal takeLast() {
        try {
            return this.deque.takeLast();
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (take! deque)", ex);
        }
    }

    @Override
    public void clear() {
        this.deque.clear();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.DEQUEUE;
    }

    @Override
    public Object convertToJavaObject() {
        return Arrays.stream(this.deque.toArray(new VncVal[0])).map(v -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.deque.iterator();
    }

    public String toString() {
        return "(" + Printer.join(this.toVncList(), " ", true) + ")";
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return "(" + Printer.join(this.toVncList(), " ", print_machine_readably) + ")";
    }

    private VncVal toNil(VncVal val) {
        return val == null ? Constants.Nil : val;
    }
}

