/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.io.timeandspace.cronscheduler;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.time.Clock;
import java.time.Duration;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.jcip.annotations.NotThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.repackage.io.timeandspace.cronscheduler.OneShotTasksShutdownPolicy;
import org.repackage.io.timeandspace.cronscheduler.PeriodicScheduling;
import org.repackage.io.timeandspace.cronscheduler.ThreadPoolExecutor;

class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor {
    volatile boolean removeOnCancel;
    private static final AtomicLong sequencer = new AtomicLong();

    void delayedExecute(ScheduledFutureTask<?> task) {
        if (this.isShutdown()) {
            this.reject(task);
        } else {
            this.getQueueInternal().addInternal(task);
            if (this.isShutdown() && this.remove(task)) {
                task.cancel(false);
            } else {
                this.ensurePrestart();
            }
        }
    }

    void reExecutePeriodic(ScheduledFutureTask<?> task) {
        if (!this.isShutdown()) {
            this.getQueueInternal().addInternal(task);
            if (!this.isShutdown() || !this.remove(task)) {
                this.ensurePrestart();
                return;
            }
        }
        task.cancel(false);
    }

    @Override
    void onShutdown(OneShotTasksShutdownPolicy oneShotTasksShutdownPolicy) {
        DelayedWorkQueue q = this.getQueueInternal();
        boolean keepDelayed = oneShotTasksShutdownPolicy == OneShotTasksShutdownPolicy.EXECUTE_DELAYED;
        for (ScheduledFutureTask<?> t : q.toArray()) {
            if (((ScheduledFutureTask)t).periodicScheduling == null && (keepDelayed || t.getDelayMillis() <= 0L) && !t.isCancelled() || !q.remove(t)) continue;
            t.cancel(false);
        }
        this.tryTerminate();
    }

    public ScheduledThreadPoolExecutor(Clock timeProvider, Duration syncPeriod, ThreadFactory threadFactory, Consumer<String> backwardTimeShiftLogger) {
        super(timeProvider, syncPeriod, new DelayedWorkQueue(), threadFactory, backwardTimeShiftLogger);
    }

    void setRemoveOnCancelPolicy(boolean value) {
        this.removeOnCancel = value;
    }

    boolean getRemoveOnCancelPolicy() {
        return this.removeOnCancel;
    }

    @Override
    public void shutdown(OneShotTasksShutdownPolicy oneShotTasksShutdownPolicy) {
        super.shutdown(oneShotTasksShutdownPolicy);
    }

    @Override
    public List<Future<?>> shutdownNow() {
        return super.shutdownNow();
    }

    public Collection<? extends Future<?>> getTasks() {
        return this.getQueueInternal();
    }

    static class DelayedWorkQueue
    extends AbstractCollection<ScheduledFutureTask<?>> {
        private static final int INITIAL_CAPACITY = 16;
        @GuardedBy(value="lock")
        private ScheduledFutureTask<?>[] queue = new ScheduledFutureTask[16];
        private final ReentrantLock lock = new ReentrantLock();
        @GuardedBy(value="lock")
        private int size;
        @GuardedBy(value="lock")
        private Thread leader;
        @GuardedBy(value="lock")
        private final Condition available = this.lock.newCondition();

        DelayedWorkQueue() {
        }

        private static void setIndex(ScheduledFutureTask<?> f, int idx) {
            f.heapIndex = idx;
        }

        @GuardedBy(value="lock")
        private void siftUp(int k, ScheduledFutureTask<?> key) {
            int parent;
            ScheduledFutureTask<?> e;
            while (k > 0 && key.compareTo(e = this.queue[parent = k - 1 >>> 1]) < 0) {
                this.queue[k] = e;
                DelayedWorkQueue.setIndex(e, k);
                k = parent;
            }
            this.queue[k] = key;
            DelayedWorkQueue.setIndex(key, k);
        }

        @GuardedBy(value="lock")
        private void siftDown(int k, ScheduledFutureTask<?> key) {
            int half = this.size >>> 1;
            while (k < half) {
                int child = (k << 1) + 1;
                ScheduledFutureTask<?> c = this.queue[child];
                int right = child + 1;
                if (right < this.size && c.compareTo(this.queue[right]) > 0) {
                    child = right;
                    c = this.queue[child];
                }
                if (key.compareTo(c) <= 0) break;
                this.queue[k] = c;
                DelayedWorkQueue.setIndex(c, k);
                k = child;
            }
            this.queue[k] = key;
            DelayedWorkQueue.setIndex(key, k);
        }

        @GuardedBy(value="lock")
        private void grow() {
            int oldCapacity = this.queue.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            this.queue = Arrays.copyOf(this.queue, newCapacity);
        }

        @GuardedBy(value="lock")
        private int indexOf(Object x) {
            if (x != null) {
                if (x instanceof ScheduledFutureTask) {
                    int i = ((ScheduledFutureTask)x).heapIndex;
                    if (i >= 0 && i < this.size && this.queue[i] == x) {
                        return i;
                    }
                } else {
                    for (int i = 0; i < this.size; ++i) {
                        if (!x.equals(this.queue[i])) continue;
                        return i;
                    }
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object x) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                boolean bl = this.indexOf(x) != -1;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object x) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i = this.indexOf(x);
                if (i < 0) {
                    boolean bl = false;
                    return bl;
                }
                DelayedWorkQueue.setIndex(this.queue[i], -1);
                int s = --this.size;
                ScheduledFutureTask<?> replacement = this.queue[s];
                this.queue[s] = null;
                if (s != i) {
                    this.siftDown(i, replacement);
                    if (this.queue[i] == replacement) {
                        this.siftUp(i, replacement);
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public int size() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int n = this.size;
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addInternal(ScheduledFutureTask<?> e) {
            if (e == null) {
                throw new NullPointerException();
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i = this.size;
                if (i >= this.queue.length) {
                    this.grow();
                }
                this.size = i + 1;
                if (i == 0) {
                    this.queue[0] = e;
                    DelayedWorkQueue.setIndex(e, 0);
                } else {
                    this.siftUp(i, e);
                }
                if (this.queue[0] == e) {
                    this.leader = null;
                    this.available.signal();
                }
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rebuild(long newTimeMillis) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                for (int i = 0; i < this.size; ++i) {
                    ScheduledFutureTask<?> task = this.queue[i];
                    if (((ScheduledFutureTask)task).periodicScheduling == null || !((ScheduledFutureTask)task).periodicScheduling.rewind(newTimeMillis)) continue;
                    this.siftUp(i, task);
                }
            }
            finally {
                lock.unlock();
            }
        }

        private ScheduledFutureTask<?> finishPoll(ScheduledFutureTask<?> f) {
            int s = --this.size;
            ScheduledFutureTask<?> x = this.queue[s];
            this.queue[s] = null;
            if (s != 0) {
                this.siftDown(0, x);
            }
            DelayedWorkQueue.setIndex(f, -1);
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public ScheduledFutureTask<?> poll(long timeout, TimeUnit unit) throws InterruptedException {
            nanos = unit.toNanos(timeout);
            lock = this.lock;
            lock.lockInterruptibly();
            while (true) lbl-1000:
            // 5 sources

            {
                if ((first = this.queue[0]) == null) {
                    if (nanos <= 0L) {
                        var8_7 = null;
                        return var8_7;
                    }
                    nanos = this.available.awaitNanos(nanos);
                    continue;
                }
                delay = TimeUnit.MILLISECONDS.toNanos(first.getDelayMillis());
                if (delay <= 0L) {
                    var10_8 = this.finishPoll(first);
                    return var10_8;
                }
                if (nanos <= 0L) {
                    var10_8 = null;
                    return var10_8;
                }
                first = null;
                if (nanos < delay || this.leader != null) {
                    nanos = this.available.awaitNanos(nanos);
                    continue;
                }
                this.leader = thisThread = Thread.currentThread();
                try {
                    timeLeft = this.available.awaitNanos(delay);
                    nanos -= delay - timeLeft;
                }
                finally {
                    if (this.leader != thisThread) continue;
                    this.leader = null;
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (this.leader == null && this.queue[0] != null) {
                    this.available.signal();
                }
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                for (int i = 0; i < this.size; ++i) {
                    ScheduledFutureTask<?> t = this.queue[i];
                    if (t == null) continue;
                    this.queue[i] = null;
                    DelayedWorkQueue.setIndex(t, -1);
                }
                this.size = 0;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drainTo(Collection<? super ScheduledFutureTask<?>> c) {
            Objects.requireNonNull(c);
            if (c == this) {
                throw new IllegalArgumentException();
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                ScheduledFutureTask<?> first;
                while ((first = this.queue[0]) != null && first.getDelayMillis() <= 0L) {
                    c.add(first);
                    this.finishPoll(first);
                }
            }
            finally {
                lock.unlock();
            }
        }

        @NotNull
        public ScheduledFutureTask<?>[] toArray() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                ScheduledFutureTask[] scheduledFutureTaskArray = (ScheduledFutureTask[])Arrays.copyOf(this.queue, this.size, ScheduledFutureTask[].class);
                return scheduledFutureTaskArray;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public <T> T[] toArray(T[] a) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (a.length < this.size) {
                    T[] TArray = Arrays.copyOf(this.queue, this.size, a.getClass());
                    return TArray;
                }
                System.arraycopy(this.queue, 0, a, 0, this.size);
                if (a.length > this.size) {
                    a[this.size] = null;
                }
                T[] TArray = a;
                return TArray;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<ScheduledFutureTask<?>> iterator() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                Itr itr = new Itr(Arrays.copyOf(this.queue, this.size));
                return itr;
            }
            finally {
                lock.unlock();
            }
        }

        private class Itr
        implements Iterator<ScheduledFutureTask<?>> {
            final ScheduledFutureTask<?>[] array;
            int cursor;
            int lastRet = -1;

            Itr(ScheduledFutureTask<?>[] array) {
                this.array = array;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.array.length;
            }

            @Override
            public ScheduledFutureTask<?> next() {
                if (this.cursor >= this.array.length) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.cursor++;
                return this.array[this.lastRet];
            }

            @Override
            public void remove() {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                DelayedWorkQueue.this.remove(this.array[this.lastRet]);
                this.lastRet = -1;
            }
        }
    }

    @NotThreadSafe
    class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements ScheduledFuture<V> {
        private final long sequenceNumber;
        private final long triggerTimeMillis;
        private final PeriodicScheduling<V> periodicScheduling;
        int heapIndex;

        ScheduledFutureTask(Runnable r, V result, long triggerTimeMillis) {
            super(r, result);
            this.triggerTimeMillis = triggerTimeMillis;
            this.periodicScheduling = null;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long triggerTimeMillis) {
            super(callable);
            this.triggerTimeMillis = triggerTimeMillis;
            this.periodicScheduling = null;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(PeriodicScheduling<V> periodicScheduling) {
            super(Objects.requireNonNull(periodicScheduling));
            this.triggerTimeMillis = 0L;
            this.periodicScheduling = periodicScheduling;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        private long nextScheduledRunTimeMillis() {
            if (this.periodicScheduling != null) {
                return this.periodicScheduling.nextScheduledRunTimeMillis();
            }
            return this.triggerTimeMillis;
        }

        long getDelayMillis() {
            return this.nextScheduledRunTimeMillis() - ScheduledThreadPoolExecutor.this.timeProvider.millis();
        }

        @Override
        @Deprecated
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.nextScheduledRunTimeMillis() - ScheduledThreadPoolExecutor.this.timeProvider.millis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.nextScheduledRunTimeMillis() - x.nextScheduledRunTimeMillis();
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelayMillis() - other.getDelay(TimeUnit.MILLISECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && ScheduledThreadPoolExecutor.this.removeOnCancel && this.heapIndex >= 0) {
                ScheduledThreadPoolExecutor.this.remove(this);
            }
            return cancelled;
        }

        @Override
        public void run() {
            if (ScheduledThreadPoolExecutor.this.isShutdown()) {
                this.cancel(false);
            } else if (this.periodicScheduling == null) {
                super.run();
            } else if (super.runAndReset()) {
                this.periodicScheduling.setNextRunTime();
                ScheduledThreadPoolExecutor.this.reExecutePeriodic(this);
            }
        }
    }
}

