/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.impl.util;

import java.util.List;
import org.repackage.com.github.jlangch.aviron.impl.util.StringUtils;

public class ShellResult {
    private final String stdout;
    private final String stderr;
    private final int exitCode;

    public ShellResult(String stdout, String stderr, int exitCode) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.exitCode = exitCode;
    }

    public String getStdout() {
        return this.stdout;
    }

    public List<String> getStdoutLines() {
        return StringUtils.splitIntoLines(this.stdout);
    }

    public String getStderr() {
        return this.stderr;
    }

    public List<String> getStderrLines() {
        return StringUtils.splitIntoLines(this.stderr);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean isZeroExitCode() {
        return this.exitCode == 0;
    }

    public String toString() {
        String err = StringUtils.trimToNull(this.stderr);
        String out = StringUtils.trimToNull(this.stdout);
        StringBuilder sb = new StringBuilder();
        sb.append("Exit code: " + this.exitCode);
        if (out == null) {
            sb.append(System.lineSeparator());
            sb.append("[stdout]  empty");
            sb.append(System.lineSeparator());
        } else {
            sb.append(System.lineSeparator());
            sb.append("[stdout]");
            sb.append(System.lineSeparator());
            sb.append(out);
        }
        if (err == null) {
            sb.append(System.lineSeparator());
            sb.append("[stderr]  empty");
            sb.append(System.lineSeparator());
        } else {
            sb.append(System.lineSeparator());
            sb.append("[stderr]");
            sb.append(System.lineSeparator());
            sb.append(err);
        }
        return sb.toString();
    }
}

