/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl.util;

import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.util.ipc.impl.util.Json;
import java.util.ArrayList;
import java.util.List;

public class JsonBuilder {
    final List<VncVal> elements = new ArrayList<VncVal>();

    public JsonBuilder add(String key, String value) {
        this.elements.add(new VncString(key));
        this.elements.add(new VncString(value));
        return this;
    }

    public JsonBuilder add(String key, int value) {
        this.elements.add(new VncString(key));
        this.elements.add(new VncInteger(value));
        return this;
    }

    public JsonBuilder add(String key, long value) {
        this.elements.add(new VncString(key));
        this.elements.add(new VncLong(value));
        return this;
    }

    public JsonBuilder add(String key, boolean value) {
        this.elements.add(new VncString(key));
        this.elements.add(VncBoolean.of(value));
        return this;
    }

    public String toJson(boolean pretty) {
        VncHashMap map = VncHashMap.of(this.elements.toArray(new VncVal[0]));
        return Json.writeJson(map, pretty);
    }
}

