/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.UUIDHelper;
import com.github.jlangch.venice.util.ipc.MessageType;
import com.github.jlangch.venice.util.ipc.ResponseStatus;
import com.github.jlangch.venice.util.ipc.impl.Message;
import com.github.jlangch.venice.util.ipc.impl.Topics;
import com.github.jlangch.venice.util.ipc.impl.util.ExceptionUtil;
import com.github.jlangch.venice.util.ipc.impl.util.IO;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Objects;

public class Protocol {
    private static final int PROTOCOL_VERSION = 1;

    public static void sendMessage(SocketChannel ch, Message message) {
        Objects.requireNonNull(ch);
        Objects.requireNonNull(message);
        ByteBuffer header = ByteBuffer.allocate(40);
        header.put((byte)118);
        header.put((byte)110);
        header.putInt(1);
        header.putInt(message.getType().getValue());
        header.putShort(message.isOneway() ? (short)1 : 0);
        header.putInt(message.getResponseStatus().getValue());
        header.putLong(message.getTimestamp());
        header.put(UUIDHelper.convertUUIDToBytes(message.getId()));
        header.flip();
        IO.writeFully(ch, header);
        if (StringUtil.isBlank(message.getCharset())) {
            IO.writeFrame(ch, null);
        } else {
            byte[] charsetData = message.getCharset().getBytes(Charset.forName("UTF8"));
            ByteBuffer charset = ByteBuffer.allocate(charsetData.length);
            charset.put(charsetData);
            charset.flip();
            IO.writeFrame(ch, charset);
        }
        byte[] topicData = Topics.encode(message.getTopics()).getBytes(Charset.forName("UTF8"));
        ByteBuffer topic = ByteBuffer.allocate(topicData.length);
        topic.put(topicData);
        topic.flip();
        IO.writeFrame(ch, topic);
        byte[] queueData = StringUtil.trimToEmpty(message.getQueueName()).getBytes(Charset.forName("UTF8"));
        ByteBuffer queue = ByteBuffer.allocate(queueData.length);
        queue.put(queueData);
        queue.flip();
        IO.writeFrame(ch, queue);
        byte[] mimetypeData = message.getMimetype().getBytes(Charset.forName("UTF8"));
        ByteBuffer mimetype = ByteBuffer.allocate(mimetypeData.length);
        mimetype.put(mimetypeData);
        mimetype.flip();
        IO.writeFrame(ch, mimetype);
        byte[] payloadData = message.getData();
        ByteBuffer payload = ByteBuffer.allocate(payloadData.length);
        payload.put(payloadData);
        payload.flip();
        IO.writeFrame(ch, payload);
    }

    public static Message receiveMessage(SocketChannel ch) {
        Objects.requireNonNull(ch);
        try {
            ByteBuffer header = ByteBuffer.allocate(40);
            int bytesRead = ch.read(header);
            if (bytesRead < 0) {
                throw new EofException("Failed to read data from channel, channel EOF reached!");
            }
            header.flip();
            byte magic1 = header.get();
            byte magic2 = header.get();
            int version = header.getInt();
            int typeCode = header.getInt();
            short oneway = header.getShort();
            int statusCode = header.getInt();
            long timestamp = header.getLong();
            byte[] uuid = new byte[16];
            header.get(uuid);
            MessageType type = MessageType.fromCode(typeCode);
            ResponseStatus status = ResponseStatus.fromCode(statusCode);
            if (magic1 != 118 || magic2 != 110) {
                throw new VncException("Received unknown message (bad magic bytes)!");
            }
            if (version != 1) {
                throw new VncException("Received message with unsupported protocol version " + version + "!");
            }
            ByteBuffer charsetFrame = IO.readFrame(ch);
            String charset = charsetFrame.hasRemaining() ? new String(charsetFrame.array(), Charset.forName("UTF8")) : null;
            ByteBuffer topicFrame = IO.readFrame(ch);
            String topics = topicFrame.hasRemaining() ? new String(topicFrame.array(), Charset.forName("UTF8")) : "*";
            ByteBuffer queueFrame = IO.readFrame(ch);
            String queue = queueFrame.hasRemaining() ? new String(queueFrame.array(), Charset.forName("UTF8")) : "";
            ByteBuffer mimetypeFrame = IO.readFrame(ch);
            String mimetype = mimetypeFrame.hasRemaining() ? new String(mimetypeFrame.array(), Charset.forName("UTF8")) : "application/octet-stream";
            ByteBuffer payloadFrame = IO.readFrame(ch);
            byte[] data = payloadFrame.array();
            if (status == null) {
                throw new VncException("Received illegal status code " + statusCode + "!");
            }
            return new Message(UUIDHelper.convertBytesToUUID(uuid), type, status, oneway == 1, StringUtil.trimToNull(queue), timestamp, Topics.decode(topics), mimetype, charset, data);
        }
        catch (IOException ex) {
            if (ExceptionUtil.isBrokenPipeException(ex)) {
                throw new VncException("Failed to read data from channel, channel was closed!", ex);
            }
            throw new VncException("Failed to read data from channel!", ex);
        }
    }
}

