/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.util.ipc.IMessage;
import com.github.jlangch.venice.util.ipc.MessageType;
import com.github.jlangch.venice.util.ipc.ResponseStatus;
import com.github.jlangch.venice.util.ipc.impl.Topics;
import com.github.jlangch.venice.util.ipc.impl.util.Json;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class Message
implements IMessage {
    public static final long QUEUENAME_MAX_LEN = 100L;
    public static final long MIMETYPE_MAX_LEN = 100L;
    public static final long CHARSET_MAX_LEN = 50L;
    private final UUID id;
    private final MessageType type;
    private final ResponseStatus responseStatus;
    private final boolean oneway;
    private final String queueName;
    private final long timestamp;
    private final Topics topics;
    private final String mimetype;
    private final String charset;
    private final byte[] data;

    public Message(MessageType type, ResponseStatus responseStatus, boolean oneway, Topics topics, String mimetype, String charset, byte[] data) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(responseStatus);
        Objects.requireNonNull(topics);
        Objects.requireNonNull(mimetype);
        Objects.requireNonNull(data);
        Message.validateMimetype(mimetype);
        Message.validateCharset(charset);
        this.id = UUID.randomUUID();
        this.type = type;
        this.responseStatus = responseStatus;
        this.oneway = oneway;
        this.queueName = null;
        this.timestamp = Instant.now().toEpochMilli();
        this.topics = topics;
        this.mimetype = mimetype;
        this.charset = charset;
        this.data = data;
    }

    public Message(UUID id, MessageType type, ResponseStatus responseStatus, boolean oneway, String queueName, long timestamp, Topics topics, String mimetype, String charset, byte[] data) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(responseStatus);
        Objects.requireNonNull(topics);
        Objects.requireNonNull(mimetype);
        Objects.requireNonNull(data);
        Message.validateMimetype(mimetype);
        Message.validateCharset(charset);
        this.id = id == null ? UUID.randomUUID() : id;
        this.type = type;
        this.responseStatus = responseStatus;
        this.oneway = oneway;
        this.queueName = StringUtil.trimToNull(queueName);
        this.timestamp = timestamp <= 0L ? Instant.now().toEpochMilli() : timestamp;
        this.topics = topics;
        this.mimetype = mimetype;
        this.charset = charset;
        this.data = data;
    }

    public Message withType(MessageType type, boolean oneway) {
        Objects.requireNonNull(type);
        return new Message(this.id, type, this.responseStatus, oneway, null, this.timestamp, this.topics, this.mimetype, this.charset, this.data);
    }

    public Message withResponseStatus(ResponseStatus responseStatus) {
        Objects.requireNonNull(responseStatus);
        return new Message(this.id, this.type, responseStatus, this.oneway, this.queueName, this.timestamp, this.topics, this.mimetype, this.charset, this.data);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public MessageType getType() {
        return this.type;
    }

    @Override
    public ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    @Override
    public boolean isOneway() {
        return this.oneway;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public LocalDateTime getTimestampAsLocalDateTime() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZoneId.systemDefault());
    }

    @Override
    public long getMessageAge() {
        long now = Instant.now().toEpochMilli();
        return now - this.timestamp;
    }

    @Override
    public String getTopic() {
        return this.topics.getTopic();
    }

    public Topics getTopics() {
        return this.topics;
    }

    public Set<String> getTopicsSet() {
        return this.topics.getTopicsSet();
    }

    @Override
    public String getMimetype() {
        return this.mimetype;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public String getText() {
        if (this.isTextMessage()) {
            return new String(this.data, Charset.forName(this.charset));
        }
        throw new VncException("A binary message can not be converted to text data!");
    }

    @Override
    public VncVal getVeniceData() {
        if (this.isTextMessage()) {
            if ("application/json".equals(this.getMimetype())) {
                return Json.readJson(new String(this.data, Charset.forName(this.charset)), true);
            }
            throw new VncException("A message with mimetype \"" + this.getMimetype() + "\" can not be converted to Venice data!");
        }
        throw new VncException("A binary message can not be converted to Venice data!");
    }

    @Override
    public boolean isTextMessage() {
        return this.charset != null;
    }

    @Override
    public boolean isBinaryMessage() {
        return this.charset == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s %s\n", StringUtil.padRight("Id:", 12), this.id.toString()));
        sb.append(String.format("%s %s\n", StringUtil.padRight("Type:", 12), this.type.name()));
        sb.append(String.format("%s %s\n", StringUtil.padRight("Response:", 12), this.responseStatus.name()));
        sb.append(String.format("%s %b\n", StringUtil.padRight("Oneway:", 12), this.oneway));
        sb.append(String.format("%s %s\n", StringUtil.padRight("Queue:", 12), this.queueName));
        sb.append(String.format("%s %s\n", StringUtil.padRight("Timestamp:", 12), this.getTimestampAsLocalDateTime()));
        sb.append(String.format("%s %s\n", StringUtil.padRight("Topics:", 12), Topics.encode(this.topics)));
        sb.append(String.format("%s %s\n", StringUtil.padRight("Mimetype:", 12), this.mimetype));
        sb.append(String.format("%s %s\n", StringUtil.padRight("Charset:", 12), this.charset == null ? "" : this.charset));
        sb.append(String.format("%s %s", StringUtil.padRight("Data:", 12), this.formatData()));
        return sb.toString();
    }

    private String formatData() {
        if (this.isTextMessage()) {
            String text = this.getText();
            return StringUtil.truncate(text, 80, "... (" + text.length() + ")");
        }
        return Message.formatDataLen(this.data.length);
    }

    private static String formatDataLen(int len) {
        if (len < 10240) {
            return String.valueOf(len) + "B";
        }
        if (len < 0xA00000) {
            return String.valueOf(len / 1024) + "KB";
        }
        return String.valueOf(len / 1024 / 1024) + "MB";
    }

    public static void validateMimetype(String mimetype) {
        if ((long)mimetype.length() > 100L) {
            throw new IllegalArgumentException("A mimetype is limited to 100characters!");
        }
    }

    public static void validateCharset(String charset) {
        if (charset == null) {
            return;
        }
        if (StringUtil.isBlank(charset)) {
            throw new IllegalArgumentException("A charset can be null for binary messages but must not be empty or blank!");
        }
        if ((long)charset.length() > 50L) {
            throw new IllegalArgumentException("A charset is limited to 50characters!");
        }
    }

    public static void validateQueueName(String name) {
        if (name == null) {
            return;
        }
        if (StringUtil.isBlank(name)) {
            throw new IllegalArgumentException("A queue name can be empty or blank!");
        }
        if ((long)name.length() > 100L) {
            throw new IllegalArgumentException("A queue name is limited to 100characters!");
        }
    }
}

