/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.block;

import com.github.jlangch.venice.impl.reader.CharacterReader;
import com.github.jlangch.venice.impl.reader.LineReader;
import com.github.jlangch.venice.impl.util.UTF8;
import com.github.jlangch.venice.impl.util.markdown.block.TableBlock;
import com.github.jlangch.venice.impl.util.markdown.block.TableColFmt;
import com.github.jlangch.venice.impl.util.markdown.block.TableColFmtParser;
import com.github.jlangch.venice.impl.util.markdown.chunk.Chunks;
import com.github.jlangch.venice.impl.util.markdown.chunk.LineBreakChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.RawChunk;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TableBlockParser {
    private static final int EOF = -1;
    private final LineReader reader;

    public TableBlockParser(LineReader reader) {
        this.reader = reader;
    }

    public TableBlock parse() {
        if (this.reader.eof()) {
            return new TableBlock();
        }
        List<String> rawRows = this.parseRawRows();
        if (rawRows.isEmpty()) {
            return new TableBlock();
        }
        List<List<String>> cells = rawRows.stream().map(r -> this.split((String)r)).collect(Collectors.toList());
        int cols = ((List)cells.get(0)).size();
        if (this.isFormatRow((List)cells.get(0))) {
            List formatRow = (List)cells.get(0);
            List<List<String>> body = cells.subList(1, cells.size());
            TableBlock block = new TableBlock(cols, this.parseColFormats(formatRow), this.toChunks2(body));
            block.parseChunks();
            return block;
        }
        if (cells.size() > 1 && this.isFormatRow((List)cells.get(1))) {
            List<String> headerRow = cells.get(0);
            List<String> formatRow = cells.get(1);
            List<List<String>> body = cells.subList(2, cells.size());
            TableBlock block = new TableBlock(cols, this.parseColFormats(formatRow), this.toChunks(headerRow), this.toChunks2(body));
            block.parseChunks();
            return block;
        }
        List<List<String>> body = cells;
        TableBlock block = new TableBlock(cols, this.toChunks2(body));
        block.parseChunks();
        return block;
    }

    public static boolean isBlockStart(String line) {
        return TableBlockParser.isRow(line);
    }

    private static boolean isRow(String line) {
        return line.matches(" *[|].*[|] *");
    }

    private List<String> parseRawRows() {
        ArrayList<String> rows = new ArrayList<String>();
        String line = this.reader.peek();
        while (line != null && TableBlockParser.isRow(line)) {
            this.reader.consume();
            rows.add(line.trim().replaceAll("&nbsp;", String.valueOf(UTF8.ZERO_WIDTH_SPACE)));
            line = this.reader.peek();
        }
        return rows;
    }

    private List<String> split(String line) {
        CharacterReader reader = new CharacterReader(line);
        ArrayList<String> cells = new ArrayList<String>();
        StringBuilder cell = new StringBuilder();
        int ch = reader.peek();
        if (ch == 124) {
            reader.consume();
        }
        while (true) {
            ch = reader.peek();
            reader.consume();
            if (ch == -1) break;
            if (ch == 92) {
                int next = reader.peek();
                if (next == 124) {
                    reader.consume();
                    cell.append((char)next);
                    continue;
                }
                cell.append((char)ch);
                continue;
            }
            if (ch == 124) {
                cells.add(cell.toString().trim());
                cell = new StringBuilder();
                continue;
            }
            cell.append((char)ch);
        }
        return cells;
    }

    private List<TableColFmt> parseColFormats(List<String> rows) {
        ArrayList<TableColFmt> align = new ArrayList<TableColFmt>();
        TableColFmtParser parser = new TableColFmtParser();
        for (String c : rows) {
            TableColFmt fmt = parser.parse(c);
            align.add(fmt == null ? new TableColFmt() : fmt);
        }
        return align;
    }

    private boolean isFormatRow(List<String> row) {
        for (String col : row) {
            if (new TableColFmtParser().parse(col) == null) continue;
            return true;
        }
        return false;
    }

    private List<Chunks> toChunks(List<String> list) {
        return list.stream().map(s -> this.parseLine((String)s)).collect(Collectors.toList());
    }

    private List<List<Chunks>> toChunks2(List<List<String>> list) {
        return list.stream().map(l -> this.toChunks((List<String>)l)).collect(Collectors.toList());
    }

    private Chunks parseLine(String line) {
        Chunks chunks = new Chunks();
        if (line.contains("\u00b6")) {
            CharacterReader reader = new CharacterReader(line);
            String chunk = "";
            while (true) {
                int ch = reader.peek();
                reader.consume();
                if (ch == -1) break;
                if (ch == 92) {
                    int next = reader.peek();
                    if (next == 182) {
                        reader.consume();
                        chunk = chunk + (char)next;
                        continue;
                    }
                    chunk = chunk + (char)ch;
                    continue;
                }
                if (ch == 182) {
                    chunks.add(new RawChunk(chunk.trim()));
                    chunks.add(new LineBreakChunk());
                    chunk = "";
                    continue;
                }
                chunk = chunk + (char)ch;
            }
            chunks.add(new RawChunk(chunk.trim()));
        } else {
            chunks.add(new RawChunk(line.trim()));
        }
        return chunks;
    }
}

