/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.repl.ReplResultHistory;
import com.github.jlangch.venice.impl.repl.TerminalPrinter;
import com.github.jlangch.venice.impl.thread.ThreadBridge;
import com.github.jlangch.venice.impl.threadpool.ThreadPoolUtil;
import com.github.jlangch.venice.impl.types.VncVal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ScriptExecuter {
    private List<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
    private final AtomicLong asyncCounter = new AtomicLong(1L);
    private final ExecutorService executor = Executors.newCachedThreadPool(ThreadPoolUtil.createCountedThreadFactory("repl-async-pool", true));

    public void runSync(String script, IVeniceInterpreter venice, Env env, TerminalPrinter printer, String resultPrefix, ReplResultHistory resultHistory, Consumer<Exception> errorHandler) {
        try {
            VncVal result = venice.RE(script, "user", env);
            if (result != null) {
                printer.println("result", resultPrefix + venice.PRINT(result));
                if (resultHistory != null && !resultHistory.isResultHistorySymbol(script)) {
                    resultHistory.add(result);
                }
            }
        }
        catch (Exception ex) {
            errorHandler.accept(ex);
        }
    }

    public void runAsync(String script, IVeniceInterpreter venice, Env env, TerminalPrinter printer, String resultPrefix, ReplResultHistory resultHistory, Consumer<Exception> errorHandler) {
        long asyncID = this.asyncCounter.getAndIncrement();
        printer.println("debug", String.format("[%d] Async ...", asyncID));
        Thread replThread = Thread.currentThread();
        ThreadBridge threadBridge = ThreadBridge.create("run-script-async");
        Callable<Boolean> task = threadBridge.bridgeCallable(() -> {
            try {
                VncVal result = venice.RE(script, "user", env);
                printer.println("result", String.format("[%d] %s%s", asyncID, resultPrefix, venice.PRINT(result)));
                printer.println("debug", String.format("[%d] Async execution finished.", asyncID));
                if (resultHistory != null && !resultHistory.isResultHistorySymbol(script)) {
                    resultHistory.add(result);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Boolean bl = true;
                return bl;
            }
            catch (InterruptedException ex) {
                printer.println("debug", "\nScript under debugging interrupted and terminated!");
                Boolean bl = false;
                return bl;
            }
            catch (Exception ex) {
                errorHandler.accept(ex);
                Boolean bl = false;
                return bl;
            }
            finally {
                replThread.interrupt();
            }
        });
        this.futures.add(this.executor.submit(task));
    }

    public void runDebuggerExpressionAsync(String expr, IVeniceInterpreter venice, Env env, TerminalPrinter printer, Consumer<Exception> errorHandler) {
        ThreadBridge threadBridge = ThreadBridge.create("run-script-async");
        Callable<Boolean> task = threadBridge.bridgeCallable(() -> {
            try {
                Env safeEnv = new Env(env);
                VncVal result = venice.RE(expr, "debugger", safeEnv);
                printer.println("debug", venice.PRINT(result));
                return true;
            }
            catch (Exception ex) {
                errorHandler.accept(ex);
                return false;
            }
        });
        try {
            this.futures.add(this.executor.submit(task));
        }
        catch (Exception ex) {
            errorHandler.accept(ex);
        }
    }

    public boolean runInitialLoadFile(String loadFile, IVeniceInterpreter venice, Env env, TerminalPrinter printer, String resultPrefix) {
        try {
            if (loadFile != null) {
                printer.println("stdout", "Loading file \"" + loadFile + "\"");
                VncVal result = venice.RE("(load-file \"" + loadFile + "\")", "user", env);
                printer.println("stdout", resultPrefix + venice.PRINT(result));
            }
            return true;
        }
        catch (Exception ex) {
            printer.printex("error", ex);
            return false;
        }
    }

    public void cancelAsyncScripts() {
        this.futures.forEach(f -> f.cancel(true));
        this.futures = this.futures.stream().filter(f -> !f.isDone()).collect(Collectors.toList());
    }
}

