/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.thread.ThreadBridge;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.util.ipc.IMessage;
import com.github.jlangch.venice.util.ipc.MessageFactory;
import com.github.jlangch.venice.util.ipc.ResponseStatus;
import com.github.jlangch.venice.util.ipc.TcpClient;
import com.github.jlangch.venice.util.ipc.TcpServer;
import com.github.jlangch.venice.util.ipc.impl.util.Json;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;

public class IPCFunctions {
    public static VncFunction ipc_server = new VncFunction("ipc/server", (VncVal)VncFunction.meta().arglists("(ipc/server port handler & options)").doc("Create a new server on the specified port.\n\n*Arguments:* \n\n| port p    | The TCP/IP port |\n| handler h | A single argument handler function.\u00b6 E.g.: a simple echo handler: `(fn [m] m)`.\u00b6 The handler receives the request messsage and returns a response message. In case of a one-way request message the server discards the handler's response if it is not `nil`.|\n\n*Options:* \n\n| :max-connections n  | The number of the max connections the server can handle in parallel. Defaults to 20.|\n| :max-message-size n | The max size of the message payload. Defaults to `200MB`.\u00b6 The max size can be specified as a number like `20000` or a number with a unit like `:20KB`, or `:20MB`|\n\n**The server must be closed after use!**").examples("(do                                                     \n  (defn echo-handler [m]                                \n    (println \"REQUEST:  \" (ipc/message->map m))       \n    m)                                                  \n                                                        \n  (try-with [server (ipc/server 33333 echo-handler)     \n             client (ipc/client \"localhost\" 33333)]   \n    (->> (ipc/plain-text-message \"test\" \"hello\")    \n         (ipc/send client)                              \n         (ipc/message->map)                             \n         (println \"RESPONSE: \"))))                    ").seeAlso("ipc/client", "ipc/close", "ipc/running?", "ipc/send", "ipc/send-oneway", "ipc/send-async", "ipc/publish", "ipc/subscribe", "ipc/text-message", "ipc/plain-text-message", "ipc/binary-message", "ipc/message->map", "ipc/message->json", "ipc/create-queue", "ipc/remove-queue", "ipc/server-status", "ipc/server-thread-pool-statistics").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            int port = Coerce.toVncLong(args.first()).getIntValue();
            VncFunction handler = Coerce.toVncFunction(args.second());
            VncHashMap options = VncHashMap.ofAll(args.slice(2));
            VncVal maxConnVal = options.get(new VncKeyword("max-connections"));
            VncVal maxMsgSizeVal = options.get(new VncKeyword("max-message-size"));
            int maxConn = maxConnVal == Constants.Nil ? 0 : Coerce.toVncLong(maxConnVal).getIntValue();
            long maxMsgSize = IPCFunctions.convertMaxMessageSizeToLong(maxMsgSizeVal);
            CallFrame[] cf = new CallFrame[]{new CallFrame(this, args), new CallFrame(handler)};
            ThreadBridge threadBridge = ThreadBridge.create("tcp-server-handler", cf, new ThreadBridge.Options[0]);
            Function<IMessage, IMessage> handlerWrapper = threadBridge.bridgeFunction(m -> {
                VncJavaObject request = new VncJavaObject(m);
                VncVal response = handler.applyOf(request);
                return Coerce.toVncJavaObject(response, IMessage.class);
            });
            TcpServer server = new TcpServer(port);
            if (maxConn > 0) {
                server.setMaximumParallelConnections(maxConn);
            }
            if (maxMsgSize > 0L) {
                server.setMaximumMessageSize(maxMsgSize);
            }
            server.start(handlerWrapper);
            return new VncJavaObject(server);
        }
    };
    public static VncFunction ipc_client = new VncFunction("ipc/client", (VncVal)VncFunction.meta().arglists("(ipc/client port)", "(ipc/client host port & options)").doc("Create a new client connecting to a server on the specified host and port.\n\n*Arguments:* \n\n| port p | The server's TCP/IP port |\n| host h | The server's TCP/IP host |\n\n*Options:* \n\n| :max-parallel-tasks n | The max number of parallel tasks (e.g. sending async messages) the client can handle. Defaults to 10. |\n| :max-message-size n   | The max size of the message payload. Defaults to `200MB`.\u00b6 The max size can be specified as a number like `20000` or a number with a unit like `:20KB`, or `:20MB`|\n\n**The client must be closed after use!**").examples("(do                                                               \n  (defn echo-handler [m]                                          \n    (println \"REQUEST:  \" (ipc/message->map m))                 \n    m)                                                            \n                                                                  \n  (defn send [client msg]                                         \n    (->> (ipc/send client msg)                                    \n         (ipc/message->map)                                       \n         (println \"RESPONSE: \")))                               \n                                                                  \n  (try-with [server   (ipc/server 33333 echo-handler)             \n             client-1 (ipc/client 33333)                          \n             client-2 (ipc/client \"localhost\" 33333)            \n             client-3 (ipc/client :localhost 33333)]              \n    (send client-1 (ipc/plain-text-message \"test\" \"hello\"))   \n    (send client-2 (ipc/plain-text-message \"test\" \"hello\"))   \n    (send client-3 (ipc/plain-text-message \"test\" \"hello\")))) ").seeAlso("ipc/server", "ipc/close", "ipc/running?", "ipc/send", "ipc/send-oneway", "ipc/send-async", "ipc/publish", "ipc/subscribe", "ipc/offer", "ipc/poll", "ipc/text-message", "ipc/plain-text-message", "ipc/binary-message", "ipc/message->map", "ipc/message->json", "ipc/client-thread-pool-statistics").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                int port = Coerce.toVncLong(args.first()).getIntValue();
                TcpClient client = new TcpClient(port);
                client.open();
                return new VncJavaObject(client);
            }
            String host = Types.isVncKeyword(args.first()) ? Coerce.toVncKeyword(args.first()).getSimpleName() : Coerce.toVncString(args.first()).getValue();
            int port = Coerce.toVncLong(args.second()).getIntValue();
            VncHashMap options = VncHashMap.ofAll(args.slice(2));
            VncVal maxParallelTasksVal = options.get(new VncKeyword("max-parallel-tasks"));
            VncVal maxMsgSizeVal = options.get(new VncKeyword("max-message-size"));
            int maxParallelTasks = maxParallelTasksVal == Constants.Nil ? 0 : Coerce.toVncLong(maxParallelTasksVal).getIntValue();
            long maxMsgSize = IPCFunctions.convertMaxMessageSizeToLong(maxMsgSizeVal);
            TcpClient client = new TcpClient(host, port);
            if (maxParallelTasks > 0) {
                client.setMaximumParallelTasks(maxParallelTasks);
            }
            if (maxMsgSize > 0L) {
                client.setMaximumMessageSize(maxMsgSize);
            }
            client.open();
            return new VncJavaObject(client);
        }
    };
    public static VncFunction ipc_runnningQ = new VncFunction("ipc/running?", (VncVal)VncFunction.meta().arglists("(ipc/running? server)", "(ipc/running? client)").doc("Return `true` if the server or client is running else `false`").examples("(do                                                         \n  (defn echo-handler [m] m)                                 \n  (try-with [server (ipc/server 33333 echo-handler)         \n             client (ipc/client \"localhost\" 33333)]       \n    (println \"Server running:\" (ipc/running? server))     \n    (println \"Client running:\" (ipc/running? client))))   ").seeAlso("ipc/client", "ipc/server", "ipc/close").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object delegate = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (delegate instanceof TcpServer) {
                return VncBoolean.of(((TcpServer)delegate).isRunning());
            }
            if (delegate instanceof TcpClient) {
                return VncBoolean.of(((TcpClient)delegate).isRunning());
            }
            throw new VncException("Function 'ipc/running?' expects either a TcpServer or a TcpClient!");
        }
    };
    public static VncFunction ipc_close = new VncFunction("ipc/close", (VncVal)VncFunction.meta().arglists("(ipc/close server)", "(ipc/close client)").doc("Closes a server or client").examples(";; prefer try-with-resources to safely close server and client    \n(do                                                               \n  (defn echo-handler [m] m)                                       \n  (try-with [server (ipc/server 33333 echo-handler)               \n             client (ipc/client \"localhost\" 33333)]             \n    (println \"Server running:\" (ipc/running? server))           \n    (println \"Client running:\" (ipc/running? client))))         ", ";; explicitly closing server and client                           \n(do                                                               \n  (defn echo-handler [m] m)                                       \n  (let [server (ipc/server 33333 echo-handler)                    \n        client (ipc/client \"localhost\" 33333)]                  \n    (println \"Server running:\" (ipc/running? server))           \n    (println \"Client running:\" (ipc/running? client))           \n    (ipc/close client)                                            \n    (ipc/close server)))                                           ").seeAlso("ipc/client", "ipc/server", "ipc/running?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object delegate = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (delegate instanceof TcpServer) {
                try {
                    ((TcpServer)delegate).close();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to close IPC server", ex);
                }
                return Constants.Nil;
            }
            if (delegate instanceof TcpClient) {
                try {
                    ((TcpClient)delegate).close();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to close IPC client", ex);
                }
                return Constants.Nil;
            }
            throw new VncException("Function 'ipc/close' expects either a TcpServer or a TcpClient!");
        }
    };
    public static VncFunction ipc_send = new VncFunction("ipc/send", (VncVal)VncFunction.meta().arglists("(ipc/send client message)", "(ipc/send client timeout message)").doc("Sends a message to the server the client is associated with. \n\nThe optional timeout is given in milliseconds.\n\nReturns the server's response message or `nil` if the message is declared as one-way message. Throws a timeout exception if the response is not received within the timeout time.\n\nThe response message has one of these status:\n\n  * `:OK`            - request handled successfully and response holds the data\n  * `:SERVER_ERROR`  - indicates a server side error while processing the request \n  * `:BAD_REQUEST`   - invalid request, details in the payload\n  * `:HANDLER_ERROR` - an error in the server's request processing handler\n\n*Arguments:* \n\n| client c  | A client to send the message from|\n| timeout t | A timeout in milliseconds for receiving the response|\n| message m | The message to send|").examples(";; echo handler                                                   \n;; request: \"hello\" => echo => response: \"hello\"              \n(do                                                               \n  (defn echo-handler [m] m)                                       \n  (try-with [server (ipc/server 33333 echo-handler)               \n             client (ipc/client \"localhost\" 33333)]             \n    (->> (ipc/plain-text-message \"test\" \"hello\")              \n         (ipc/send client)                                        \n         (ipc/message->map)                                       \n         (println))))                                             ", ";; handler processing JSON message data                           \n;; request: {\"x\": 100, \"y\": 200} => add => response: {\"z\": 300}  \n(do                                                               \n  (defn handler [m]                                               \n    (let [data   (json/read-str (. m :getText))                   \n          result (json/write-str { \"z\" (+ (get data \"x\") (get data \"y\"))})]  \n      (ipc/text-message (. m :getTopic)                           \n                        \"application/json\" :UTF-8               \n                        result)))                                 \n  (try-with [server (ipc/server 33333 handler)                    \n             client (ipc/client \"localhost\" 33333)]             \n    (->> (ipc/text-message \"test\"                               \n                           \"application/json\" :UTF-8            \n                           (json/write-str {\"x\" 100 \"y\" 200}))\n         (ipc/send client 2000)                                   \n         (ipc/message->map)                                       \n         (println))))                                             ", ";; handler with remote code execution                             \n;; request: \"(+ 1 2)\" => exec => response: \"3\"                \n(do                                                               \n  (defn handler [m]                                               \n    (let [cmd    (. m :getText)                                   \n          result (str (eval (read-string cmd)))]                  \n      (ipc/plain-text-message (. m :getTopic)                     \n                              result)))                           \n  (try-with [server (ipc/server 33333 handler)                    \n             client (ipc/client \"localhost\" 33333)]             \n    (->> (ipc/plain-text-message \"exec\" \"(+ 1 2)\")            \n         (ipc/send client)                                        \n         (ipc/message->map)                                       \n         (println))))                                             ").seeAlso("ipc/client", "ipc/server", "ipc/close", "ipc/running?", "ipc/send-async", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            boolean hasTimeout = args.size() > 2;
            TcpClient client = Coerce.toVncJavaObject(args.nth(0), TcpClient.class);
            long timeout = hasTimeout ? Coerce.toVncLong(args.nth(1)).toJavaLong() : 0L;
            IMessage request = Coerce.toVncJavaObject(args.nth(hasTimeout ? 2 : 1), IMessage.class);
            if (timeout <= 0L) {
                IMessage response = client.sendMessage(request);
                return response == null ? Constants.Nil : new VncJavaObject(response);
            }
            IMessage response = client.sendMessage(request, timeout, TimeUnit.MILLISECONDS);
            return response == null ? Constants.Nil : new VncJavaObject(response);
        }
    };
    public static VncFunction ipc_send_oneway = new VncFunction("ipc/send-oneway", (VncVal)VncFunction.meta().arglists("(ipc/send-oneway client message)").doc("Sends a one-way message to the server the client is associated with. \n\nDoes not wait for response and returns always `nil`.").examples("(do                                                      \n  (defn echo-handler [m] m)                              \n  (try-with [server (ipc/server 33333 echo-handler)      \n             client (ipc/client \"localhost\" 33333)]    \n    (->> (ipc/plain-text-message \"test\" \"hello\")     \n         (ipc/send-oneway client))))                     ").seeAlso("ipc/client", "ipc/server", "ipc/close", "ipc/running?", "ipc/send-async", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            boolean hasTimeout = args.size() > 2;
            TcpClient client = Coerce.toVncJavaObject(args.nth(0), TcpClient.class);
            long timeout = hasTimeout ? Coerce.toVncLong(args.nth(1)).toJavaLong() : 0L;
            IMessage request = Coerce.toVncJavaObject(args.nth(hasTimeout ? 2 : 1), IMessage.class);
            if (timeout <= 0L) {
                IMessage response = client.sendMessage(request);
                return response == null ? Constants.Nil : new VncJavaObject(response);
            }
            IMessage response = client.sendMessage(request, timeout, TimeUnit.MILLISECONDS);
            return response == null ? Constants.Nil : new VncJavaObject(response);
        }
    };
    public static VncFunction ipc_send_async = new VncFunction("ipc/send-async", (VncVal)VncFunction.meta().arglists("(ipc/send-async client message)").doc("Sends a message asynchronously to the server the client is associated with. \n\nReturns a future to get the server's response message.\n\nThe response message has one of these status:\n\n  * `:OK`            - request handled successfully and response holds the data\n  * `:SERVER_ERROR`  - indicates a server side error while processing the request \n  * `:BAD_REQUEST`   - invalid request, details in the payload\n  * `:HANDLER_ERROR` - an error in the server's request processing handler").examples("(do                                                      \n  (defn echo-handler [m] m)                              \n  (try-with [server (ipc/server 33333 echo-handler)      \n             client (ipc/client \"localhost\" 33333)]    \n    (->> (ipc/plain-text-message \"test\" \"hello\")     \n         (ipc/send-async client)                         \n         (deref)                                         \n         (ipc/message->map)                              \n         (println))))                                    ").seeAlso("ipc/client", "ipc/server", "ipc/close", "ipc/running?", "ipc/send", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            TcpClient client = Coerce.toVncJavaObject(args.first(), TcpClient.class);
            IMessage request = Coerce.toVncJavaObject(args.second(), IMessage.class);
            Future<IMessage> response = client.sendMessageAsync(request);
            return response == null ? Constants.Nil : new VncJavaObject(new FutureWrapper(response));
        }
    };
    public static VncFunction ipc_subscribe = new VncFunction("ipc/subscribe", (VncVal)VncFunction.meta().arglists("(ipc/subscribe client topic msg-handler)").doc("Subscribe to a topic.\n\nPuts this client into subscription mode and listens for messages of the specified topic.\n\nTo unsubscribe from the topics just close the client.\n\nThe response message has one of these status:\n\n  * `:OK`            - subscription added. Subscribed messages will be delivered through the 'msg-handler'\n  * `:SERVER_ERROR`  - indicates a server side error while processing the request\n  * `:BAD_REQUEST`   - invalid request, details in the payload").examples("(do                                                                            \n  (def mutex 0)                                                                \n                                                                               \n  ;; the server handler is not involved with publish/subscribe!                \n  (defn server-handler [m]                                                     \n    (locking mutex (println (ipc/message->map m)))                             \n    m)                                                                         \n                                                                               \n  (defn client-subscription-handler [m]                                        \n    (locking mutex (println \"SUB:\" (ipc/message->map m))))                   \n                                                                               \n  (try-with [server   (ipc/server 33333 server-handler)                        \n             client-1 (ipc/client \"localhost\" 33333)                         \n             client-2 (ipc/client \"localhost\" 33333)                         \n             client-3 (ipc/client \"localhost\" 33333)]                        \n    ;; client 'client-1' subscribes to 'alpha' messages                        \n    (ipc/subscribe client-1 \"alpha\" client-subscription-handler)             \n                                                                               \n    ;; client 'client-2' subscribes to 'alpha' and 'beta' messages             \n    (ipc/subscribe client-2 [\"alpha\" \"beta\"] client-subscription-handler)  \n                                                                               \n    ;; client 'client-3' publishes message                                     \n    (->> (ipc/plain-text-message \"alpha\" \"hello\")                          \n         (ipc/publish client-3))                                               \n    (->> (ipc/plain-text-message \"beta\" \"hello\")                           \n         (ipc/publish client-3))                                               \n                                                                               \n    (sleep 300)                                                                \n                                                                               \n    ;; print server status and statistics                                      \n    (locking mutex (println \"STATUS:\" (ipc/server-status client-3)))))       ").seeAlso("ipc/publish", "ipc/client", "ipc/server", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            TcpClient client = Coerce.toVncJavaObject(args.nth(0), TcpClient.class);
            VncVal topicVal = args.nth(1);
            VncFunction handler = Coerce.toVncFunction(args.nth(2));
            HashSet<String> topics = new HashSet<String>();
            if (Types.isVncString(topicVal)) {
                topics.add(Coerce.toVncString(topicVal).getValue());
            } else if (Types.isVncSequence(topicVal)) {
                Coerce.toVncSequence(topicVal).forEach((Consumer<? super VncVal>)((Consumer<VncVal>)t -> {
                    if (!Types.isVncString(t)) {
                        throw new VncException("Function 'ipc/subscribe' expects either a single string topic or a sequence of topic strings!");
                    }
                    topics.add(Coerce.toVncString(t).getValue());
                }));
            } else {
                throw new VncException("Function 'ipc/subscribe' expects either a single string topic or a sequence of topic strings!");
            }
            CallFrame[] cf = new CallFrame[]{new CallFrame(this, args), new CallFrame(handler)};
            ThreadBridge threadBridge = ThreadBridge.create("tcp-subscribe-handler", cf, new ThreadBridge.Options[0]);
            Consumer<IMessage> handlerWrapper = threadBridge.bridgeConsumer(m -> {
                try {
                    handler.applyOf(new VncJavaObject(m));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            IMessage response = client.subscribe(topics, handlerWrapper);
            return new VncJavaObject(response);
        }
    };
    public static VncFunction ipc_publish = new VncFunction("ipc/publish", (VncVal)VncFunction.meta().arglists("(ipc/publish client message)").doc("Publishes a messages to all clients that have subscribed to themessage's topic.\n\nThe response message has one of these status:\n\n  * `:OK`            - message successfully published\n  * `:SERVER_ERROR`  - indicates a server side error while processing the request \n  * `:BAD_REQUEST`   - invalid request, details in the payload\n\nNote: a client in subscription mode can not send or publish messages!").examples("(do                                                                            \n  (def mutex 0)                                                                \n                                                                               \n  ;; the server handler is not involved with publish/subscribe!                \n  (defn server-handler [m]                                                     \n    (locking mutex (println (ipc/message->map m)))                             \n    m)                                                                         \n                                                                               \n  (defn client-subscribe-handler [m]                                           \n    (locking mutex (println \"SUB:\" (ipc/message->map m))))                   \n                                                                               \n  (try-with [server   (ipc/server 33333 server-handler)                        \n             client-1 (ipc/client \"localhost\" 33333)                         \n             client-2 (ipc/client \"localhost\" 33333)]                        \n    ;; client 'client-1' subscribes to 'test' messages                         \n    (ipc/subscribe client-1 \"test\" client-subscribe-handler)                 \n                                                                               \n    ;; client 'client-2' publishes a 'test' message                            \n    (->> (ipc/plain-text-message \"test\" \"hello\")                           \n         (ipc/publish client-2))                                               \n                                                                               \n    (sleep 300)                                                                \n                                                                               \n    ;; print server status and statistics                                      \n    (locking mutex (println \"STATUS:\"(ipc/server-status client-2)))))        ").seeAlso("ipc/subscribe", "ipc/client", "ipc/server", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            TcpClient client = Coerce.toVncJavaObject(args.nth(0), TcpClient.class);
            IMessage request = Coerce.toVncJavaObject(args.nth(1), IMessage.class);
            IMessage response = client.publish(request);
            return new VncJavaObject(response);
        }
    };
    public static VncFunction ipc_offer = new VncFunction("ipc/offer", (VncVal)VncFunction.meta().arglists("(ipc/offer client queue-name timeout message)").doc("Offers a message to the named queue.\n\n*Arguments:* \n\n| client c     | A client to send the offer message from |\n| queue-name q | A queue name to offer the message to|\n| timeout t    | A timeout in milliseconds for receiving the response|\n| message m    | The offer request message|\n\nThe server returns a response message with one of these status:\n\n  * `:OK`              - message added to the queue\n  * `:SERVER_ERROR`    - indicates a server while offering the message to the queue\n  * `:BAD_REQUEST`     - invalid request, details in the payload\n  * `:QUEUE_NOT_FOUND` - the queue does not exist\n  * `:QUEUE_FULL`      - the queue is full, offer rejected").examples("(do                                                                       \n  (defn echo-handler [m] m)                                               \n                                                                          \n  (try-with [server (ipc/server 33333 echo-handler)                       \n             client1 (ipc/client \"localhost\" 33333)                     \n             client2 (ipc/client \"localhost\" 33333)]                    \n    (let [order-queue \"orders\"                                          \n          capacity    100_000                                             \n          order       (ipc/venice-message                                 \n                            \"order\"                                     \n                            {:item \"espresso\", :count 2})]              \n      (ipc/create-queue server order-queue capacity)                      \n      (->> (ipc/message->json true order)                                 \n           (println \"ORDER:\"))                                          \n      (->> (ipc/offer client1 order-queue 300 order)                      \n           (ipc/message->json true)                                       \n           (println \"OFFERED:\"))                                        \n      (->> (ipc/poll client2 order-queue 300)                             \n           (ipc/message->json true)                                       \n           (println \"POLLED:\")))))                                      ").seeAlso("ipc/server", "ipc/client", "ipc/poll", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/create-queue", "ipc/remove-queue").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 4);
            TcpClient client = Coerce.toVncJavaObject(args.first(), TcpClient.class);
            String name = Coerce.toVncString(args.second()).getValue();
            long timeout = Coerce.toVncLong(args.third()).toJavaLong();
            IMessage request = Coerce.toVncJavaObject(args.fourth(), IMessage.class);
            return new VncJavaObject(client.offer(request, name, timeout, TimeUnit.MILLISECONDS));
        }
    };
    public static VncFunction ipc_poll = new VncFunction("ipc/poll", (VncVal)VncFunction.meta().arglists("(ipc/poll client queue-name timeout)").doc("Polls a message from the named queue.\n\n*Arguments:* \n\n| client c     | A client to send the poll message from |\n| queue-name q | A queue name to poll the message to|\n| timeout t    | A timeout in milliseconds for receiving the response|\n| message m    | The poll request message|\n\nThe server returns a response message with one of these status:\n\n  * `:OK`              - message successfully polled from the queue, response holds the data\n  * `:SERVER_ERROR`    - indicates a server while polling a message from the queue\n  * `:BAD_REQUEST`     - invalid request, details in the payload\n  * `:QUEUE_NOT_FOUND` - the queue does not exist\n  * `:QUEUE_EMPTY`     - the queue is empty").examples("(do                                                                       \n  (defn echo-handler [m] m)                                               \n                                                                          \n  (try-with [server (ipc/server 33333 echo-handler)                       \n             client1 (ipc/client \"localhost\" 33333)                     \n             client2 (ipc/client \"localhost\" 33333)]                    \n    (let [order-queue \"orders\"                                          \n          capacity    100_000                                             \n          order       (ipc/venice-message                                 \n                            \"order\"                                     \n                            {:item \"espresso\", :count 2})]              \n      (ipc/create-queue server order-queue capacity)                      \n      (->> (ipc/message->json true order)                                 \n           (println \"ORDER:\"))                                          \n      (->> (ipc/offer client1 order-queue 300 order)                      \n           (ipc/message->json true)                                       \n           (println \"OFFERED:\"))                                        \n      (->> (ipc/poll client2 order-queue 300)                             \n           (ipc/message->json true)                                       \n           (println \"POLLED:\")))))                                      ").seeAlso("ipc/server", "ipc/client", "ipc/offer", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/create-queue", "ipc/remove-queue").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            TcpClient client = Coerce.toVncJavaObject(args.first(), TcpClient.class);
            String name = Coerce.toVncString(args.second()).getValue();
            long timeout = Coerce.toVncLong(args.third()).toJavaLong();
            return new VncJavaObject(client.poll(name, timeout, TimeUnit.MILLISECONDS));
        }
    };
    public static VncFunction ipc_server_status = new VncFunction("ipc/server-status", (VncVal)VncFunction.meta().arglists("(ipc/server-status client)").doc("Returns the status and statistics of the server the client is connected to.").examples("(do                                                               \n  (defn echo-handler [m] m)                                       \n  (try-with [server (ipc/server 33333 echo-handler)               \n             client (ipc/client \"localhost\" 33333)]             \n    (->> (ipc/plain-text-message \"test\" \"hello\")              \n         (ipc/send client))                                       \n    (println \"STATUS:\" (ipc/server-status client))))            ").seeAlso("ipc/server-thread-pool-statistics", "ipc/server", "ipc/close", "ipc/running?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            TcpClient client = Coerce.toVncJavaObject(args.nth(0), TcpClient.class);
            IMessage response = client.sendMessage(MessageFactory.text("tcp-server/status", "appliaction/json", "UTF-8", ""), 5L, TimeUnit.SECONDS);
            if (response.getResponseStatus() == ResponseStatus.OK) {
                try {
                    return Json.readJson(response.getText(), true);
                }
                catch (Exception ex) {
                    throw new VncException("Failed to get server status", ex);
                }
            }
            throw new VncException("Failed to get server status");
        }
    };
    public static VncFunction ipc_server_thread_pool_statistics = new VncFunction("ipc/server-thread-pool-statistics", (VncVal)VncFunction.meta().arglists("(ipc/server-thread-pool-statistics client)").doc("Returns the server's thread pool statistics the client is connected to.").examples("(do                                                                   \n  (defn echo-handler [m] m)                                           \n  (try-with [server (ipc/server 33333 echo-handler)                   \n             client (ipc/client \"localhost\" 33333)]                 \n    (->> (ipc/plain-text-message \"test\" \"hello\")                  \n         (ipc/send client))                                           \n    (println \"STATS:\" (ipc/server-thread-pool-statistics client)))) ").seeAlso("ipc/server-status", "ipc/server", "ipc/client", "ipc/close", "ipc/running?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            TcpClient client = Coerce.toVncJavaObject(args.nth(0), TcpClient.class);
            IMessage response = client.sendMessage(MessageFactory.text("tcp-server/thread-pool-statistics", "appliaction/json", "UTF-8", ""), 5L, TimeUnit.SECONDS);
            if (response.getResponseStatus() == ResponseStatus.OK) {
                try {
                    return Json.readJson(response.getText(), true);
                }
                catch (Exception ex) {
                    throw new VncException("Failed to get server thread pool statistics", ex);
                }
            }
            throw new VncException("Failed to get server thread pool statistics");
        }
    };
    public static VncFunction ipc_client_thread_pool_statistics = new VncFunction("ipc/client-thread-pool-statistics", (VncVal)VncFunction.meta().arglists("(ipc/client-thread-pool-statistics client)").doc("Returns the client's thread pool statistics.").examples("(do                                                               \n  (defn echo-handler [m] m)                                       \n  (try-with [server (ipc/server 33333 echo-handler)               \n             client (ipc/client \"localhost\" 33333)]             \n    (->> (ipc/plain-text-message \"test\" \"hello\")              \n         (ipc/send client))                                       \n    (println (ipc/client-thread-pool-statistics client))))        ").seeAlso("ipc/client", "ipc/close", "ipc/running?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            TcpClient client = Coerce.toVncJavaObject(args.nth(0), TcpClient.class);
            IMessage response = client.sendMessage(MessageFactory.text("client/thread-pool-statistics", "appliaction/json", "UTF-8", ""), 5L, TimeUnit.SECONDS);
            if (response.getResponseStatus() == ResponseStatus.OK) {
                try {
                    return Json.readJson(response.getText(), true);
                }
                catch (Exception ex) {
                    throw new VncException("Failed to get client thread pool statistics", ex);
                }
            }
            throw new VncException("Failed to get client thread pool statistics");
        }
    };
    public static VncFunction ipc_text_message = new VncFunction("ipc/text-message", (VncVal)VncFunction.meta().arglists("(ipc/text-message topic mimetype charset text)").doc("Creates a text message\n\n*Arguments:* \n\n| topic t    | A topic (string) |\n| mimetype m | The mimetype of the payload text. A string like 'text/plain' |\n| charset c  | The charset of the payload text. A keyword like `:UTF-8`|\n| text t     | The message payload text (a string)|").examples("(->> (ipc/text-message \"test\"                         \n                       \"text/plain\" :UTF-8 \"hello\")  \n     (ipc/message->map)                                  \n     (println))                                          ").seeAlso("ipc/server", "ipc/client", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map", "ipc/message->json", "ipc/oneway?", "ipc/response-ok?", "ipc/response-err?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 4);
            VncString topic = Coerce.toVncString(args.nth(0));
            VncString mimetype = Coerce.toVncString(args.nth(1));
            VncKeyword charset = Coerce.toVncKeyword(args.nth(2));
            VncVal textVal = args.nth(3);
            String text = Types.isVncString(textVal) ? ((VncString)textVal).getValue() : textVal.toString(true);
            IMessage msg = MessageFactory.text(topic.getValue(), mimetype.getValue(), charset.getSimpleName(), text);
            return new VncJavaObject(msg);
        }
    };
    public static VncFunction ipc_plain_text_message = new VncFunction("ipc/plain-text-message", (VncVal)VncFunction.meta().arglists("(ipc/plain-text-message topic text)").doc("Creates a plain text message with mimetype `text/plain` and charset `:UTF-8`.\n\n*Arguments:* \n\n| topic t | A topic (string) |\n| text t  | The message payload text (a string)|").examples("(->> (ipc/plain-text-message \"test\" \"hello\")  \n     (ipc/message->map)                           \n     (println))                                   ").seeAlso("ipc/server", "ipc/client", "ipc/text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map", "ipc/message->json", "ipc/oneway?", "ipc/response-ok?", "ipc/response-err?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncString topic = Coerce.toVncString(args.nth(0));
            VncVal textVal = args.nth(1);
            String text = Types.isVncString(textVal) ? ((VncString)textVal).getValue() : textVal.toString(true);
            IMessage msg = MessageFactory.text(topic.getValue(), "text/plain", "UTF-8", text);
            return new VncJavaObject(msg);
        }
    };
    public static VncFunction ipc_binary_message = new VncFunction("ipc/binary-message", (VncVal)VncFunction.meta().arglists("(ipc/binary-message topic mimetype data)").doc("Creates a binary message.\n\n*Arguments:* \n\n| topic t    | A topic (string) |\n| mimetype m | The mimetype of the payload data. A string like 'application/octet-stream', 'image/png'|\n| data d     | The message payload binary data (a bytebuf)|").examples("(->> (ipc/binary-message \"test\"                        \n                         \"application/octet-stream\"    \n                         (bytebuf [0 1 2 3 4 5 6 7]))    \n     (ipc/message->map)                                  \n     (println))                                          ").seeAlso("ipc/server", "ipc/client", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/message->map", "ipc/message->json", "ipc/oneway?", "ipc/response-ok?", "ipc/response-err?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            VncString topic = Coerce.toVncString(args.nth(0));
            VncString mimetype = Coerce.toVncString(args.nth(1));
            VncByteBuffer data = Coerce.toVncByteBuffer(args.nth(2));
            IMessage msg = MessageFactory.binary(topic.getValue(), mimetype.getValue(), data.getBytes());
            return new VncJavaObject(msg);
        }
    };
    public static VncFunction ipc_venice_message = new VncFunction("ipc/venice-message", (VncVal)VncFunction.meta().arglists("(ipc/venice-message topic data)").doc("Creates a venice message.\n\nThe Venice data is serialized as JSON (mimetype: 'application/json') for transport within the message.\n\n*Arguments:* \n\n| topic t    | A topic (string) |\n| data d     | The message payload Venice data (e.g.: a map, list, ...)|").examples("(->> (ipc/venice-message \"test\"                        \n                         {:a 100, :b 200})               \n     (ipc/message->map)                                  \n     (println))                                          ").seeAlso("ipc/server", "ipc/client", "ipc/text-message", "ipc/plain-text-message", "ipc/message->map", "ipc/message->json", "ipc/oneway?", "ipc/response-ok?", "ipc/response-err?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncString topic = Coerce.toVncString(args.first());
            VncVal data = args.second();
            IMessage msg = MessageFactory.venice(topic.getValue(), data);
            return new VncJavaObject(msg);
        }
    };
    public static VncFunction ipc_message_field = new VncFunction("ipc/message-field", (VncVal)VncFunction.meta().arglists("(ipc/message-field message field)").doc("Returns a specific field from the message. \n\n```\n           Message                         set by \n \u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510   \n \u2502 ID                            \u2502   by send, publish/subscribe method\n \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524   \n \u2502 Message Type                  \u2502   by send, publish/subscribe method\n \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524   \n \u2502 Oneway                        \u2502   by Client or framework method\n \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524   \n \u2502 Response Status               \u2502   by server response processor\n \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524   \n \u2502 Timestamp                     \u2502   by message creator\n \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524   \n \u2502 Topic                         \u2502   by Client\n \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524   \n \u2502 Payload Mimetype              \u2502   by Client\n \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524   \n \u2502 Payload Charset               \u2502   by Client if payload data is a string else null\n \u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524   \n \u2502 Payload data                  \u2502   by Client\n \u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518   \n```\n\n**Supported field names:** \n\n  * `:id`               - the message's technical ID\n  * `:type`             - the message type (request, response, ..) \n  * `:oneway?`          - `true` if one-way message else `false`\n  * `:response-status`  - the response status (ok, bad request, ...) \n  * `:timestamp`        - the message's creation timestamp in milliseconds since epoch\n  * `:topic`            - the topic\n  * `:payload-mimetype` - the payload data mimetype\n  * `:payload-charset`  - the payload data charset (if payload is a text form)\n  * `:payload-text`     - the payload converted to text data if payload is textual data else error\n  * `:payload-binary`   - the payload binary data (thr raw message binary data)\n  * `:payload-venice`   - the payload converted venice data if mimetype is 'application/json' else error\n\n**Message type:** \n\n  * `:REQUEST`     - a request message\n  * `:PUBLISH`     - a publish message\n  * `:SUBSCRIBE`   - a subscribe message\n  * `:UNSUBSCRIBE` - an unsubscribe message\n  * `:OFFER`       - an offer message for a queue\n  * `:POLL`        - a poll message from a queue\n  * `:RESPONSE`    - a response to a request message\n  * `:NULL`        - a message with yet undefined type\n\n**Response status:** \n\n  * `:OK`              - a response message for a successfully processed request\n  * `:SERVER_ERROR`    - a response indicating a server side error while processing the request \n  * `:BAD_REQUEST`     - invalid request\n  * `:HANDLER_ERROR`   - a server handler error in the server's request processing\n  * `:QUEUE_NOT_FOUND` - the required queue does not exist\n  * `:QUEUE_EMPTY`     - the adressed queue in a poll request is empty\n  * `:QUEUE_FULL`      - the adressed queue in offer request is full\n  * `:NULL`            - a message with yet undefined status").examples("(let [m (ipc/text-message \"test\"                         \n                          \"text/plain\"                   \n                          :UTF-8                           \n                          \"Hello!\")]                     \n  (println (ipc/message-field m :id))                      \n  (println (ipc/message-field m :type))                    \n  (println (ipc/message-field m :oneway?))                 \n  (println (ipc/message-field m :timestamp))               \n  (println (ipc/message-field m :response-status))         \n  (println (ipc/message-field m :topic))                   \n  (println (ipc/message-field m :payload-mimetype))        \n  (println (ipc/message-field m :payload-charset))         \n  (println (ipc/message-field m :payload-text))            \n  (println (ipc/message-field m :payload-binary)))         ", "(let [m (ipc/binary-message \"test\"                       \n                            \"application/octet-stream\"   \n                            (bytebuf [0 1 2 3 4 5 6 7]))]  \n  (println (ipc/message-field m :id))                      \n  (println (ipc/message-field m :type))                    \n  (println (ipc/message-field m :oneway?))                 \n  (println (ipc/message-field m :timestamp))               \n  (println (ipc/message-field m :response-status))         \n  (println (ipc/message-field m :topic))                   \n  (println (ipc/message-field m :payload-mimetype))        \n  (println (ipc/message-field m :payload-charset))         \n  (println (ipc/message-field m :payload-binary)))         ", "(let [m (ipc/venice-message \"test\"                  \n                            {:a 100, :b 200})]        \n  (println (ipc/message-field m :id))                 \n  (println (ipc/message-field m :type))               \n  (println (ipc/message-field m :oneway?))            \n  (println (ipc/message-field m :timestamp))          \n  (println (ipc/message-field m :response-status))    \n  (println (ipc/message-field m :topic))              \n  (println (ipc/message-field m :payload-mimetype))   \n  (println (ipc/message-field m :payload-charset))    \n  (println (ipc/message-field m :payload-venice)))    ").seeAlso("ipc/server", "ipc/client", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/message->map", "ipc/message->json").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            IMessage message = Coerce.toVncJavaObject(args.first(), IMessage.class);
            VncKeyword field = Coerce.toVncKeyword(args.second());
            switch (field.getSimpleName()) {
                case "id": {
                    return new VncString(message.getId().toString());
                }
                case "type": {
                    return new VncKeyword(message.getType().name());
                }
                case "timestamp": {
                    return new VncLong(message.getTimestamp());
                }
                case "oneway?": {
                    return VncBoolean.of(message.isOneway());
                }
                case "response-status": {
                    return new VncKeyword(message.getResponseStatus().name());
                }
                case "topic": {
                    return new VncString(message.getTopic());
                }
                case "payload-mimetype": {
                    return new VncString(message.getMimetype());
                }
                case "payload-charset": {
                    return message.getCharset() == null ? Constants.Nil : new VncKeyword(message.getCharset());
                }
                case "payload-text": {
                    return new VncString(message.getText());
                }
                case "payload-binary": {
                    return new VncByteBuffer(message.getData());
                }
                case "payload-venice": {
                    return message.getVeniceData();
                }
            }
            throw new VncException("Invalid message field name :" + field.getSimpleName());
        }
    };
    public static VncFunction ipc_message_to_map = new VncFunction("ipc/message->map", (VncVal)VncFunction.meta().arglists("(ipc/message->map message)").doc("Converts a message to a Venice map.\n\nReturns a Venice map with the keys:\n\n  * `:type`\n  * `:status`\n  * `:timestamp`\n  * `:topic`\n  * `:mimetype`\n  * `:charset`\n  * `:data`\n").examples("(->> (ipc/text-message \"test\"                          \n                       \"text/plain\" :UTF-8 \"hello\")  \n     (ipc/message->map))                                 ", "(->> (ipc/venice-message \"test\"                        \n                         {:a 100, :b 200})               \n     (ipc/message->map))                                 ", "(->> (ipc/binary-message \"test\"                        \n                         \"application/octet-stream\"    \n                         (bytebuf [0 1 2 3 4]))          \n     (ipc/message->map))                                 ").seeAlso("ipc/server", "ipc/client", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->json").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            IMessage m = Coerce.toVncJavaObject(args.first(), IMessage.class);
            if (m.getCharset() == null) {
                return VncOrderedMap.of(new VncKeyword("type"), new VncKeyword(m.getType().name()), new VncKeyword("status"), new VncKeyword(m.getResponseStatus().name()), new VncKeyword("timestamp"), new VncLong(m.getTimestamp()), new VncKeyword("topic"), new VncString(m.getTopic()), new VncKeyword("mimetype"), new VncString(m.getMimetype()), new VncKeyword("data"), new VncByteBuffer(m.getData()));
            }
            if ("application/json".equals(m.getMimetype())) {
                return VncOrderedMap.of(new VncKeyword("type"), new VncKeyword(m.getType().name()), new VncKeyword("status"), new VncKeyword(m.getResponseStatus().name()), new VncKeyword("timestamp"), new VncLong(m.getTimestamp()), new VncKeyword("topic"), new VncString(m.getTopic()), new VncKeyword("mimetype"), new VncString(m.getMimetype()), new VncKeyword("data"), Json.readJson(m.getText(), true));
            }
            return VncOrderedMap.of(new VncKeyword("type"), new VncKeyword(m.getType().name()), new VncKeyword("status"), new VncKeyword(m.getResponseStatus().name()), new VncKeyword("timestamp"), new VncLong(m.getTimestamp()), new VncKeyword("topic"), new VncString(m.getTopic()), new VncKeyword("mimetype"), new VncString(m.getMimetype()), new VncKeyword("charset"), new VncKeyword(m.getCharset()), new VncKeyword("text"), new VncString(m.getText()));
        }
    };
    public static VncFunction ipc_message_to_json = new VncFunction("ipc/message->json", (VncVal)VncFunction.meta().arglists("(ipc/message->json message)", "(ipc/message->json pretty message)").doc("Converts message to a Json string with optional pretty printing.\n\nReturns a Json string.").examples("(->> (ipc/text-message \"test\"                          \n                       \"text/plain\" :UTF-8 \"hello\")  \n     (ipc/message->json true))                           ", "(->> (ipc/venice-message \"test\"                        \n                         {:a 100, :b 200})               \n     (ipc/message->json true))                           ", "(->> (ipc/binary-message \"test\"                        \n                         \"application/octet-stream\"    \n                         (bytebuf [0 1 2 3 4]))          \n     (ipc/message->json true))                           ").seeAlso("ipc/server", "ipc/client", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            boolean pretty = args.size() == 1 ? false : Coerce.toVncBoolean(args.nth(0)).getValue();
            IMessage m = Coerce.toVncJavaObject(args.nth(args.size() == 1 ? 0 : 1), IMessage.class);
            VncMap data = (VncMap)ipc_message_to_map.applyOf(new VncJavaObject(m));
            return new VncString(Json.writeJson(data, pretty));
        }
    };
    public static VncFunction ipc_onewayQ = new VncFunction("ipc/oneway?", (VncVal)VncFunction.meta().arglists("(ipc/oneway? message)").doc("Returns `true` if the message is one-way else `false`.\n\nNote: the oneway flag on the message is delayed until a message is sent from the client to the server or vice versa.").examples("(do                                                               \n  (defn echo-handler [m]                                          \n     (if (ipc/oneway? m) nil m))                                  \n                                                                  \n  (try-with [server (ipc/server 33333 echo-handler)               \n             client (ipc/client \"localhost\" 33333)]             \n    (->> (ipc/plain-text-message \"test\" \"hello\")              \n         (ipc/send client)                                        \n         (ipc/message->map)                                       \n         (println))))                                             ").seeAlso("ipc/response-ok?", "ipc/response-err?", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map", "ipc/message->json").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            IMessage m = Coerce.toVncJavaObject(args.first(), IMessage.class);
            return VncBoolean.of(m.isOneway());
        }
    };
    public static VncFunction ipc_response_okQ = new VncFunction("ipc/response-ok?", (VncVal)VncFunction.meta().arglists("(ipc/response-ok? message)").doc("Returns `true` if the message response status is `:OK` else `false`.").examples("(do                                                               \n  (defn echo-handler [m] m)                                       \n  (try-with [server (ipc/server 33333 echo-handler)               \n             client (ipc/client \"localhost\" 33333)]             \n    (->> (ipc/plain-text-message \"test\" \"hello\")              \n         (ipc/send client)                                        \n         (ipc/response-ok?))))                                    ").seeAlso("ipc/oneway?", "ipc/response-err?", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map", "ipc/message->json").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            IMessage m = Coerce.toVncJavaObject(args.first(), IMessage.class);
            return VncBoolean.of(m.getResponseStatus() == ResponseStatus.OK);
        }
    };
    public static VncFunction ipc_response_errQ = new VncFunction("ipc/response-err?", (VncVal)VncFunction.meta().arglists("(ipc/oneway? message)").doc("Returns `true` if the message has a response error status else `false`.").examples("(do                                                               \n  (defn echo-handler [m] m)                                       \n  (try-with [server (ipc/server 33333 echo-handler)               \n             client (ipc/client \"localhost\" 33333)]             \n    (->> (ipc/plain-text-message \"test\" \"hello\")              \n         (ipc/send client)                                        \n         (ipc/response-err?))))                                   ").seeAlso("ipc/oneway?", "ipc/response-ok?", "ipc/text-message", "ipc/plain-text-message", "ipc/venice-message", "ipc/binary-message", "ipc/message->map", "ipc/message->json").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            IMessage m = Coerce.toVncJavaObject(args.first(), IMessage.class);
            return VncBoolean.of(m.getResponseStatus() != ResponseStatus.OK && m.getResponseStatus() != ResponseStatus.NULL);
        }
    };
    public static VncFunction ipc_create_queue = new VncFunction("ipc/create-queue", (VncVal)VncFunction.meta().arglists("(ipc/create-queue server name capacity)").doc("Creates a named queue on server. Messages can be exchanged asynchronously between two clients using a queue. Each message is delivered to exactly one client. 1 to N clients can *offer* / *poll* messages *from* / *to* the queue. \n\nReturns always `nil` or throws an exception.\n\n*Arguments:* \n\n| server s   | A server |\n| name n     | A queue name (string)|\n| capacity t | The queue's capacity (max number of messages)|").examples("(do                                                                       \n  (defn echo-handler [m] m)                                               \n                                                                          \n  (try-with [server (ipc/server 33333 echo-handler)                       \n             client1 (ipc/client \"localhost\" 33333)                     \n             client2 (ipc/client \"localhost\" 33333)]                    \n    (let [order-queue \"orders\"                                          \n          capacity    100_000                                             \n          order       (ipc/venice-message                                 \n                            \"order\"                                     \n                            {:item \"espresso\", :count 2})]              \n      (ipc/create-queue server order-queue capacity)                      \n      (->> (ipc/message->json true order)                                 \n           (println \"ORDER:\"))                                          \n      (->> (ipc/offer client1 order-queue 300 order)                      \n           (ipc/message->json true)                                       \n           (println \"OFFERED:\"))                                        \n      (->> (ipc/poll client2 order-queue 300)                             \n           (ipc/message->json true)                                       \n           (println \"POLLED:\")))))                                      ").seeAlso("ipc/server", "ipc/remove-queue", "ipc/exists-queue?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            TcpServer server = Coerce.toVncJavaObject(args.first(), TcpServer.class);
            String name = Coerce.toVncString(args.second()).getValue();
            int capacity = (int)Coerce.toVncLong(args.third()).toJavaLong();
            server.createQueue(name, capacity);
            return Constants.Nil;
        }
    };
    public static VncFunction ipc_remove_queue = new VncFunction("ipc/remove-queue", (VncVal)VncFunction.meta().arglists("(ipc/remove-queue server name)").doc("Removes a named queue from the server.\n\nReturns always `nil` or throws an exception.\n\n*Arguments:* \n\n| server s | A server |\n| name n   | A queue name (string)|").examples("(do                                                    \n  (defn echo-handler [m] m)                            \n                                                       \n  (try-with [server (ipc/server 33333 echo-handler)]   \n    (let [order-queue \"orders\"                       \n          capacity    100_000]                         \n      (ipc/create-queue server order-queue capacity)   \n      ;; ...                                           \n      (ipc/remove-queue server order-queue))))         ").seeAlso("ipc/server", "ipc/create-queue", "ipc/exists-queue?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            TcpServer server = Coerce.toVncJavaObject(args.first(), TcpServer.class);
            String name = Coerce.toVncString(args.second()).getValue();
            server.removeQueue(name);
            return Constants.Nil;
        }
    };
    public static VncFunction ipc_exists_queueQ = new VncFunction("ipc/exists-queue?", (VncVal)VncFunction.meta().arglists("(ipc/exists-queue? server name)").doc("Returns `true` if the named queue exists else `false`.\n\n*Arguments:* \n\n| server s | A server |\n| name n   | A queue name (string)|").examples("(do                                                    \n  (defn echo-handler [m] m)                            \n                                                       \n  (try-with [server (ipc/server 33333 echo-handler)]   \n    (let [order-queue \"orders\"                       \n          capacity    100_000]                         \n      (ipc/create-queue server order-queue capacity)   \n      ;; ...                                           \n      (ipc/exists-queue? server order-queue))))        ").seeAlso("ipc/server", "ipc/create-queue", "ipc/remove-queue").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            TcpServer server = Coerce.toVncJavaObject(args.first(), TcpServer.class);
            String name = Coerce.toVncString(args.second()).getValue();
            return VncBoolean.of(server.existsQueue(name));
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(ipc_server).add(ipc_client).add(ipc_close).add(ipc_runnningQ).add(ipc_send).add(ipc_send_async).add(ipc_send_oneway).add(ipc_publish).add(ipc_subscribe).add(ipc_offer).add(ipc_poll).add(ipc_text_message).add(ipc_plain_text_message).add(ipc_binary_message).add(ipc_venice_message).add(ipc_message_field).add(ipc_message_to_map).add(ipc_message_to_json).add(ipc_onewayQ).add(ipc_response_okQ).add(ipc_response_errQ).add(ipc_create_queue).add(ipc_remove_queue).add(ipc_exists_queueQ).add(ipc_server_status).add(ipc_server_thread_pool_statistics).add(ipc_client_thread_pool_statistics).toMap();

    private static long convertMaxMessageSizeToLong(VncVal val) {
        if (val == Constants.Nil) {
            return 0L;
        }
        if (Types.isVncLong(val)) {
            return Coerce.toVncLong(val).toJavaLong();
        }
        if (Types.isVncKeyword(val)) {
            String sVal = ((VncKeyword)val).getSimpleName();
            if (sVal.matches("^[1-9][0-9]*B$")) {
                return Long.parseLong(StringUtil.removeEnd(sVal, "B"));
            }
            if (sVal.matches("^[1-9][0-9]*KB$")) {
                return Long.parseLong(StringUtil.removeEnd(sVal, "KB"));
            }
            if (sVal.matches("^[1-9][0-9]*MB$")) {
                return Long.parseLong(StringUtil.removeEnd(sVal, "MB"));
            }
            throw new VncException("Invalid max-message-size value! Use 20000, 500KB, 10MB, ...");
        }
        throw new VncException("Invalid max-message-size value! Use 20000, 500KB, 10MB, ...");
    }

    private static class FutureWrapper
    implements Future<VncVal> {
        private final Future<IMessage> delegate;

        public FutureWrapper(Future<IMessage> future) {
            this.delegate = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public VncVal get() throws InterruptedException, ExecutionException {
            IMessage val = this.delegate.get();
            return val == null ? Constants.Nil : new VncJavaObject(val);
        }

        @Override
        public VncVal get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            IMessage val = this.delegate.get(timeout, unit);
            return val == null ? Constants.Nil : new VncJavaObject(val);
        }
    }
}

