/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.impl.thread.ThreadBridge;
import com.github.jlangch.venice.impl.threadpool.ThreadPoolUtil;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.impl.util.time.TimeUnitUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.repackage.io.timeandspace.cronscheduler.CronScheduler;
import org.repackage.io.timeandspace.cronscheduler.CronTask;

public class CronSchedulerFunctions {
    public static VncFunction schedule_at = new VncFunction("cron/schedule-at", (VncVal)VncFunction.meta().arglists("(schedule-at-round-times-in-day fn sync-period schedule-at)").doc("Creates and executes a one-shot scheduled task that becomes enabled at a given time.\n\nThis scheduled task is not prone to clock shifts.\n\nReturns a future. `(deref f)`, `(future? f)`, `(cancel f)`, and `(done? f)` will work on the returned future.\u00b6\n\nThis function is built on the [CronScheduler](https://github.com/TimeAndSpaceIO/CronScheduler) project.").examples("(let [sync-period     (. :java.time.Duration :ofMinutes 10)                  \n      at              (time/plus (time/local-date-time) :seconds 2)          \n      task            (fn [] (println \"Task:\" (time/local-date-time)) 100) \n      sched           (cron/schedule-at task sync-period at)]                \n   (deref sched))                                                            ").seeAlso("cron/schedule-at-fixed-rate", "cron/schedule-at-round-times-in-day").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            this.sandboxFunctionCallValidation();
            VncFunction fn = Coerce.toVncFunction(args.first());
            Duration syncPeriod = Coerce.toVncJavaObject(args.second(), Duration.class);
            LocalDateTime scheduleAt = Coerce.toVncJavaObject(args.third(), LocalDateTime.class);
            fn.sandboxFunctionCallValidation();
            ThreadBridge threadBridge = ThreadBridge.create("cron/schedule-at", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Callable<VncVal> taskWrapper = threadBridge.bridgeCallable(() -> fn.applyOf(new VncVal[0]));
            CronScheduler scheduler = CronSchedulerFunctions.createCronScheduler(syncPeriod);
            ZoneId zoneId = ZoneId.systemDefault();
            Instant instant = scheduleAt.atZone(zoneId).toInstant();
            Future<VncVal> future = scheduler.scheduleAt(instant, taskWrapper);
            return new VncJavaObject(future);
        }
    };
    public static VncFunction schedule_at_round_times_in_day = new VncFunction("cron/schedule-at-round-times-in-day", (VncVal)VncFunction.meta().arglists("(schedule-at-round-times-in-day fn sync-period schedule-period)", "(schedule-at-round-times-in-day fn sync-period schedule-period skipping-to-latest)").doc("Submits a periodic task that becomes enabled at round clock times within a day, with the given period.\n\nThis scheduled task is not prone to clock shifts.\n\nReturns a future. `(deref f)`, `(future? f)`, `(cancel f)`, and `(done? f)` will work on the returned future.\n\nThis function is built on the [CronScheduler](https://github.com/TimeAndSpaceIO/CronScheduler) project.").examples("(let [sync-period     (. :java.time.Duration :ofMinutes 10)                                   \n      schedule-period (. :java.time.Duration :ofHours 4)                                      \n      task            (fn [] (println \"Task:\" (time/local-date-time)))                      \n      sched           (cron/schedule-at-round-times-in-day task sync-period schedule-period)] \n   (sleep 24 :hours)                                                                          \n   (cancel sched))                                                                            ").seeAlso("cron/schedule-at-fixed-rate", "cron/schedule-at").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3, 4);
            this.sandboxFunctionCallValidation();
            VncFunction fn = Coerce.toVncFunction(args.first());
            Duration syncPeriod = Coerce.toVncJavaObject(args.second(), Duration.class);
            Duration schedulePeriod = Coerce.toVncJavaObject(args.third(), Duration.class);
            boolean skipToLatest = args.size() > 3 ? Coerce.toVncBoolean(args.fourth()).getValue() : true;
            fn.sandboxFunctionCallValidation();
            ThreadBridge threadBridge = ThreadBridge.create("cron/schedule-at-round-times-in-day", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Runnable taskWrapper = threadBridge.bridgeRunnable(() -> {
                try {
                    fn.applyOf(new VncVal[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            CronTask task = millis -> taskWrapper.run();
            CronScheduler scheduler = CronSchedulerFunctions.createCronScheduler(syncPeriod);
            Future<?> future = skipToLatest ? scheduler.scheduleAtRoundTimesInDaySkippingToLatest(schedulePeriod, ZoneId.systemDefault(), task) : scheduler.scheduleAtRoundTimesInDay(schedulePeriod, ZoneId.systemDefault(), task);
            return new VncJavaObject(future);
        }
    };
    public static VncFunction schedule_at_fixed_rate = new VncFunction("cron/schedule-at-fixed-rate", (VncVal)VncFunction.meta().arglists("(schedule-at-fixed-rate fn sync-period initial-delay period time-unit)", "(schedule-at-fixed-rate fn sync-period initial-delay period time-unit skipping-to-latest)").doc("Creates and executes a periodic action that becomes enabled first after the given initial delay, and subsequently with the given period.\n\nThis scheduled task is not prone to clock shifts. \n\nReturns a future. `(deref f)`, `(future? f)`, `(cancel f)`, and `(done? f)` will work on the returned future.\n\nThis function is built on the [CronScheduler](https://github.com/TimeAndSpaceIO/CronScheduler) project.").examples("(let [sync-period (. :java.time.Duration :ofMinutes 10)                        \n      task        (fn [] (println \"Task:\" (time/local-date-time)))           \n      sched       (cron/schedule-at-fixed-rate task sync-period 1 2 :seconds)] \n   (sleep 16 :seconds)                                                         \n   (cancel sched))                                                             ").seeAlso("cron/schedule-at-round-times-in-day", "cron/schedule-at").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 5, 6);
            this.sandboxFunctionCallValidation();
            VncFunction fn = Coerce.toVncFunction(args.nth(0));
            Duration syncPeriod = Coerce.toVncJavaObject(args.nth(1), Duration.class);
            VncLong delay = Coerce.toVncLong(args.nth(2));
            VncLong period = Coerce.toVncLong(args.nth(3));
            VncKeyword unit = Coerce.toVncKeyword(args.nth(4));
            boolean skipToLatest = args.size() > 5 ? Coerce.toVncBoolean(args.nth(5)).getValue() : true;
            fn.sandboxFunctionCallValidation();
            ThreadBridge threadBridge = ThreadBridge.create("cron/schedule-at-fixed-rate", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Runnable taskWrapper = threadBridge.bridgeRunnable(() -> {
                try {
                    fn.applyOf(new VncVal[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            CronTask task = millis -> taskWrapper.run();
            CronScheduler scheduler = CronSchedulerFunctions.createCronScheduler(syncPeriod);
            Future<?> future = skipToLatest ? scheduler.scheduleAtFixedRateSkippingToLatest(delay.getValue(), period.getValue(), TimeUnitUtil.toTimeUnit(unit), task) : scheduler.scheduleAtFixedRate(delay.getValue(), period.getValue(), TimeUnitUtil.toTimeUnit(unit), task);
            return new VncJavaObject(future);
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(schedule_at).add(schedule_at_round_times_in_day).add(schedule_at_fixed_rate).toMap();

    private static CronScheduler createCronScheduler(Duration syncPeriod) {
        return CronScheduler.newBuilder(syncPeriod).setThreadFactory(ThreadPoolUtil.createCountedThreadFactory("cron-scheduler", true)).build();
    }
}

