/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.algo;

public abstract class KnuthMorrisPratt {
    public static int indexOf(byte[] data, byte[] pattern, int indexFrom) {
        if (data == null) {
            throw new IllegalArgumentException("A data byte array must not be null!");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("A pattern byte array must not be null!");
        }
        if (indexFrom < 0) {
            throw new IllegalArgumentException("An indexFrom must not be negative!");
        }
        if (indexFrom > data.length - pattern.length) {
            return -1;
        }
        if (data.length == 0 || pattern.length == 0) {
            return -1;
        }
        if (data.length < pattern.length) {
            return -1;
        }
        int[] failure = KnuthMorrisPratt.computeFailure(pattern);
        int j = 0;
        for (int i = indexFrom; i < data.length; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    public static int indexOf(byte[] data, byte[] pattern, int indexFrom, int indexTo) {
        if (data == null) {
            throw new IllegalArgumentException("A data byte array must not be null!");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("A pattern byte array must not be null!");
        }
        if (indexFrom < 0) {
            throw new IllegalArgumentException("An indexFrom must not be negative!");
        }
        if (indexFrom > data.length - pattern.length) {
            return -1;
        }
        if (indexTo == 0) {
            return -1;
        }
        if (data.length == 0 || pattern.length == 0) {
            return -1;
        }
        if (data.length < pattern.length) {
            return -1;
        }
        if (indexTo < 0 || indexTo >= data.length) {
            return KnuthMorrisPratt.indexOf(data, pattern, indexFrom);
        }
        int[] failure = KnuthMorrisPratt.computeFailure(pattern);
        int j = 0;
        for (int i = indexFrom; i < data.length || i < indexTo; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

