/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io;

import com.github.jlangch.venice.impl.thread.ThreadBridge;
import com.github.jlangch.venice.impl.threadpool.GlobalThreadFactory;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class FileWatcher
implements Closeable {
    private final WatchService ws;
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final BiConsumer<Path, Exception> errorListener;
    private final Consumer<Path> registerListener;

    public FileWatcher(CallFrame[] callFrame, Path dir, BiConsumer<Path, WatchEvent.Kind<?>> eventListener, BiConsumer<Path, Exception> errorListener, Consumer<Path> terminationListener, Consumer<Path> registerListener) throws IOException {
        if (!dir.toFile().exists() || !dir.toFile().isDirectory()) {
            throw new RuntimeException("Folder " + dir + " does not exist or is not a directory");
        }
        this.ws = dir.getFileSystem().newWatchService();
        this.errorListener = errorListener;
        this.registerListener = registerListener;
        this.register(dir);
        ThreadBridge threadBridge = ThreadBridge.create("thread", callFrame, new ThreadBridge.Options[0]);
        Runnable runnable = threadBridge.bridgeRunnable(() -> {
            while (true) {
                try {
                    WatchKey key;
                    while ((key = this.ws.take()) != null) {
                        Path dirPath = this.keys.get(key);
                        if (dirPath == null) continue;
                        key.pollEvents().stream().filter(e -> e.kind() != StandardWatchEventKinds.OVERFLOW).forEach(e -> {
                            Path p = (Path)e.context();
                            Path absPath = dirPath.resolve(p);
                            if (absPath.toFile().isDirectory() && e.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                                FileWatcher.register(this.ws, this.keys, errorListener, registerListener, dir, true);
                            }
                            FileWatcher.safeRun(() -> eventListener.accept(absPath, e.kind()));
                        });
                        key.reset();
                    }
                }
                catch (ClosedWatchServiceException ex) {
                }
                catch (InterruptedException ex) {
                    continue;
                }
                catch (Exception ex) {
                    if (errorListener == null) continue;
                    FileWatcher.safeRun(() -> errorListener.accept(dir, ex));
                    continue;
                }
                break;
            }
            try {
                this.ws.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (terminationListener != null) {
                FileWatcher.safeRun(() -> terminationListener.accept(dir));
            }
        });
        Thread th = GlobalThreadFactory.newThread("venice-watch-dir", runnable);
        th.setUncaughtExceptionHandler(ThreadBridge::handleUncaughtException);
        th.start();
    }

    public void register(Path dir) throws IOException {
        if (!dir.toFile().exists() || !dir.toFile().isDirectory()) {
            throw new RuntimeException("Folder " + dir + " does not exist or is not a directory");
        }
        FileWatcher.register(this.ws, this.keys, this.errorListener, this.registerListener, dir, false);
    }

    public List<Path> getRegisteredPaths() {
        return this.keys.values().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public void close() throws IOException {
        this.ws.close();
    }

    public static VncKeyword convertEvent(WatchEvent.Kind<?> kind) {
        if (kind == null) {
            return new VncKeyword("unknown");
        }
        switch (kind.name()) {
            case "ENTRY_CREATE": {
                return new VncKeyword("created");
            }
            case "ENTRY_DELETE": {
                return new VncKeyword("deleted");
            }
            case "ENTRY_MODIFY": {
                return new VncKeyword("modified");
            }
            case "OVERFLOW": {
                return new VncKeyword("overflow");
            }
        }
        return new VncKeyword("unknown");
    }

    private static void register(WatchService ws, Map<WatchKey, Path> keys, BiConsumer<Path, Exception> errorListener, Consumer<Path> registerListener, Path dir, boolean audit) {
        block3: {
            try {
                WatchKey dirKey = dir.register(ws, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, new WatchEvent.Modifier[0]);
                keys.put(dirKey, dir);
                if (audit && registerListener != null) {
                    FileWatcher.safeRun(() -> registerListener.accept(dir));
                }
            }
            catch (Exception e) {
                if (errorListener == null) break block3;
                FileWatcher.safeRun(() -> errorListener.accept(dir, e));
            }
        }
    }

    private static void safeRun(Runnable r) {
        try {
            r.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

