/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.Watchable;
import java.util.concurrent.atomic.AtomicReference;

public class VncAtom
extends VncVal
implements IDeref {
    public static final String TYPE = ":core/atom";
    private static final long serialVersionUID = -1848883965231344442L;
    private final AtomicReference<VncVal> state = new AtomicReference();
    private final VncFunction validatorFn;
    private final Watchable watchable = new Watchable();

    public VncAtom(VncVal value) {
        super(Constants.Nil);
        this.state.set(value);
        this.validatorFn = null;
    }

    public VncAtom(VncVal value, VncFunction validatorFn, VncVal meta) {
        super(meta);
        this.state.set(value);
        this.validatorFn = validatorFn;
    }

    @Override
    public VncAtom withMeta(VncVal meta) {
        return new VncAtom(this.state.get(), this.validatorFn, MetaUtil.mergeMeta(this.getMeta(), meta));
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/val")));
    }

    public VncVal reset(VncVal newVal) {
        this.validate(newVal);
        this.state.set(newVal);
        return newVal;
    }

    @Override
    public VncVal deref() {
        return this.state.get();
    }

    public VncVal swap(VncFunction fn, VncList args) {
        VncVal newVal;
        VncVal oldVal;
        do {
            oldVal = this.deref();
            VncList new_args = VncList.of(oldVal).addAllAtEnd(args);
            newVal = fn.apply(new_args);
            this.validate(newVal);
        } while (!this.state.compareAndSet(oldVal, newVal));
        this.watchable.notifyWatches(this, oldVal, newVal);
        return this.state.get();
    }

    public VncVector swap_vals(VncFunction fn, VncList args) {
        VncVal newVal;
        VncVal oldVal;
        do {
            oldVal = this.deref();
            VncList new_args = VncList.of(oldVal).addAllAtEnd(args);
            newVal = fn.apply(new_args);
            this.validate(newVal);
        } while (!this.state.compareAndSet(oldVal, newVal));
        this.watchable.notifyWatches(this, oldVal, newVal);
        return VncVector.of(oldVal, this.state.get());
    }

    public VncVal compareAndSet(VncVal expectValue, VncVal newVal) {
        this.validate(newVal);
        VncVal oldVal = this.deref();
        if (oldVal.equals(expectValue)) {
            boolean successful = this.state.compareAndSet(oldVal, newVal);
            if (successful) {
                this.watchable.notifyWatches(this, oldVal, newVal);
            }
            return VncBoolean.of(successful);
        }
        return VncBoolean.False;
    }

    public void addWatch(VncKeyword name, VncFunction fn) {
        this.watchable.addWatch(name, fn);
    }

    public void removeWatch(VncKeyword name) {
        this.watchable.removeWatch(name);
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.ATOM;
    }

    @Override
    public Object convertToJavaObject() {
        return null;
    }

    public String toString() {
        return "(atom " + Printer.pr_str(this.state.get(), true) + ")";
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return "(atom " + Printer.pr_str(this.state.get(), print_machine_readably) + ")";
    }

    private void validate(VncVal newVal) {
        if (this.validatorFn != null) {
            try {
                VncVal ok = this.validatorFn.apply(VncList.of(newVal));
                if (VncBoolean.isFalseOrNil(ok)) {
                    throw new VncException("Invalid atom state");
                }
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new VncException("Invalid atom state");
            }
        }
    }
}

