/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.javainterop.IInvoker;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import com.github.jlangch.venice.javainterop.Interceptor;
import com.github.jlangch.venice.javainterop.ReturnValue;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.stream.Collectors;

public class SandboxRecorder
extends Interceptor {
    private final PrintWriter writer;

    public SandboxRecorder() {
        this(null);
    }

    public SandboxRecorder(ILoadPaths loadPaths) {
        super(loadPaths);
        this.writer = new PrintWriter(System.out);
    }

    public SandboxRecorder(Writer writer, ILoadPaths loadPaths) {
        super(loadPaths);
        this.writer = new PrintWriter(writer);
    }

    public SandboxRecorder(OutputStream os, ILoadPaths loadPaths) {
        super(loadPaths);
        this.writer = new PrintWriter(os);
    }

    @Override
    public ReturnValue onInvokeInstanceMethod(IInvoker invoker, Object receiver, Class<?> receiverFormalType, String method, Object ... args) throws SecurityException {
        this.format("%s:%s(%s)", this.type(receiver), method, this.arguments(args));
        return super.onInvokeInstanceMethod(invoker, receiver, receiverFormalType, method, args);
    }

    @Override
    public ReturnValue onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) throws SecurityException {
        this.format("%s:%s(%s)", this.type(receiver), method, this.arguments(args));
        return super.onInvokeStaticMethod(invoker, receiver, method, args);
    }

    @Override
    public ReturnValue onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) throws SecurityException {
        this.format("new %s(%s)", this.type(receiver), this.arguments(args));
        return super.onInvokeConstructor(invoker, receiver, args);
    }

    @Override
    public ReturnValue onGetBeanProperty(IInvoker invoker, Object receiver, String property) throws SecurityException {
        this.format("%s.!%s", this.type(receiver), property);
        return super.onGetBeanProperty(invoker, receiver, property);
    }

    @Override
    public void onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) throws SecurityException {
        this.format("%s.!%s=%s", this.type(receiver), property, this.type(value));
        super.onSetBeanProperty(invoker, receiver, property, value);
    }

    @Override
    public ReturnValue onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) throws SecurityException {
        this.format("%s.@%s", this.type(receiver), fieldName);
        return super.onGetStaticField(invoker, receiver, fieldName);
    }

    @Override
    public ReturnValue onGetInstanceField(IInvoker invoker, Object receiver, Class<?> receiverFormalType, String fieldName) throws SecurityException {
        this.format("%s.%s", this.type(receiver), fieldName);
        return super.onGetInstanceField(invoker, receiver, receiverFormalType, fieldName);
    }

    @Override
    public byte[] onLoadClassPathResource(String resourceName) throws SecurityException {
        this.format("classpath:%s", resourceName);
        return super.onLoadClassPathResource(resourceName);
    }

    @Override
    public String onReadSystemProperty(String propertyName) throws SecurityException {
        this.format("system.property:%s", propertyName);
        return super.onReadSystemProperty(propertyName);
    }

    @Override
    public String onReadSystemEnv(String name) throws SecurityException {
        this.format("system.env:%s", name);
        return super.onReadSystemEnv(name);
    }

    private void format(String fmt, Object ... args) {
        this.writer.println(String.format(fmt, args));
        this.writer.flush();
    }

    private String type(Object obj) {
        return obj == null ? "null" : (this.isClass(obj) ? this.type((Class)obj) : this.type(obj.getClass()));
    }

    private String type(Class<?> c) {
        if (c.isArray()) {
            return this.type(c.getComponentType()) + "[]";
        }
        String className = c.getName();
        return className.startsWith("java.lang.") ? className.substring("java.lang.".length()) : className;
    }

    private String arguments(Object ... args) {
        return Arrays.stream(args).map(a -> this.type(a)).collect(Collectors.joining(","));
    }

    private boolean isClass(Object obj) {
        return obj instanceof Class;
    }
}

