/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.IInvoker;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import com.github.jlangch.venice.javainterop.LoadPathsFactory;
import com.github.jlangch.venice.javainterop.ReturnValue;
import java.io.File;

public abstract class Interceptor
implements IInterceptor {
    private final ILoadPaths loadPaths;

    public Interceptor(ILoadPaths loadPaths) {
        this.loadPaths = loadPaths == null ? LoadPathsFactory.rejectAll() : loadPaths;
    }

    @Override
    public ReturnValue onInvokeInstanceMethod(IInvoker invoker, Object receiver, Class<?> receiverFormalType, String method, Object ... args) throws SecurityException {
        return invoker.callInstanceMethod(receiver, receiverFormalType, method, args);
    }

    @Override
    public ReturnValue onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) throws SecurityException {
        return invoker.callStaticMethod(receiver, method, args);
    }

    @Override
    public ReturnValue onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) throws SecurityException {
        return invoker.callConstructor(receiver, args);
    }

    @Override
    public ReturnValue onGetBeanProperty(IInvoker invoker, Object receiver, String property) throws SecurityException {
        return invoker.getBeanProperty(receiver, property);
    }

    @Override
    public void onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) throws SecurityException {
        invoker.setBeanProperty(receiver, property, value);
    }

    @Override
    public ReturnValue onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) throws SecurityException {
        return invoker.getStaticField(receiver, fieldName);
    }

    @Override
    public ReturnValue onGetInstanceField(IInvoker invoker, Object receiver, Class<?> receiverFormalType, String fieldName) throws SecurityException {
        return invoker.getInstanceField(receiver, receiverFormalType, fieldName);
    }

    @Override
    public byte[] onLoadClassPathResource(String resourceName) throws SecurityException {
        return StringUtil.isBlank(resourceName) ? null : new ClassPathResource(resourceName).getResourceAsBinary();
    }

    @Override
    public String onReadSystemProperty(String propertyName) throws SecurityException {
        return StringUtil.isBlank(propertyName) ? null : System.getProperty(propertyName);
    }

    @Override
    public String onReadSystemEnv(String name) throws SecurityException {
        return StringUtil.isBlank(name) ? null : System.getenv(name);
    }

    @Override
    public void validateVeniceFunction(String funcName) throws SecurityException {
    }

    @Override
    public void validateLoadModule(String moduleName) throws SecurityException {
    }

    @Override
    public void validateFileRead(File file) throws SecurityException {
    }

    @Override
    public void validateFileWrite(File file) throws SecurityException {
    }

    @Override
    public void validateMaxExecutionTime() throws SecurityException {
    }

    @Override
    public Integer getMaxExecutionTimeSeconds() {
        return null;
    }

    @Override
    public Integer getMaxFutureThreadPoolSize() {
        return null;
    }

    @Override
    public ILoadPaths getLoadPaths() {
        return this.loadPaths;
    }
}

