/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.cidr.collect;

import com.github.jlangch.venice.impl.util.cidr.CIDR;
import com.github.jlangch.venice.impl.util.cidr.collect.CidrTrieNode;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CidrTrie<V> {
    private volatile CidrTrieNode<V> root = new CidrTrieNode();
    private final AtomicInteger size = new AtomicInteger(0);
    private final Lock writeLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(CIDR key, V value) {
        this.acquireWriteLock();
        try {
            int ipBits = key.isIP4() ? 32 : 128;
            int highestBit = ipBits - 1;
            int lowestBit = ipBits - key.getRange();
            CidrTrieNode<V> current = this.root;
            for (int bit = highestBit; bit > lowestBit; --bit) {
                boolean isLeft = !key.getLowAddressBit(bit);
                CidrTrieNode<V> child = current.getChild(isLeft);
                if (child == null) {
                    child = new CidrTrieNode();
                    current.setChild(isLeft, child);
                }
                current = child;
            }
            boolean isLeft = !key.getLowAddressBit(lowestBit);
            CidrTrieNode<V> child = current.getChild(isLeft);
            if (child == null) {
                child = new CidrTrieNode<V>(key, value);
                current.setChild(isLeft, child);
                if (value != null) {
                    this.size.incrementAndGet();
                }
            } else {
                current.setChild(isLeft, child.withData(key, value));
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public V getValue(String ipAddr) {
        CidrTrieNode<V> node = this.getNode(CIDR.parse(ipAddr));
        return node == null ? null : (V)node.getValue();
    }

    public V getValue(CIDR key) {
        CidrTrieNode<V> node = this.getNode(key);
        return node == null ? null : (V)node.getValue();
    }

    public CIDR getCIDR(String ipAddr) {
        CIDR key = CIDR.parse(ipAddr);
        CidrTrieNode<V> node = this.getNode(key);
        return node == null ? null : node.getKey();
    }

    public void clear() {
        this.acquireWriteLock();
        try {
            this.root = new CidrTrieNode();
            this.size.set(0);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public int size() {
        return this.size.get();
    }

    private CidrTrieNode<V> getNode(CIDR key) {
        boolean isLeft;
        CidrTrieNode<V> child;
        int ipBits = key.isIP4() ? 32 : 128;
        int highestBit = ipBits - 1;
        int lowestBit = ipBits - key.getRange();
        CidrTrieNode<V> current = this.root;
        CidrTrieNode<V> lastValueNode = null;
        for (int bit = highestBit; bit >= lowestBit && (child = current.getChild(isLeft = !key.getLowAddressBit(bit))) != null; --bit) {
            if (child.hasValue()) {
                lastValueNode = child;
            }
            current = child;
        }
        return lastValueNode;
    }

    private void acquireWriteLock() {
        this.writeLock.lock();
    }

    private void releaseWriteLock() {
        this.writeLock.unlock();
    }
}

