/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.util.CallFrame;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class CallStack {
    private final ArrayDeque<CallFrame> queue;

    public CallStack() {
        this.queue = new ArrayDeque(32);
    }

    private CallStack(ArrayDeque<CallFrame> queue) {
        this.queue = queue;
    }

    public void push(CallFrame frame) {
        this.queue.push(frame);
    }

    public CallFrame pop() {
        return this.isEmpty() ? null : this.queue.pop();
    }

    public CallFrame peek() {
        return this.queue.peek();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public void clear() {
        this.queue.clear();
    }

    public CallStack copy() {
        return new CallStack((ArrayDeque<CallFrame>)this.queue.clone());
    }

    public List<String> toList() {
        ArrayList<String> list = new ArrayList<String>(this.queue.size());
        for (CallFrame f : this.queue) {
            list.add(f.toString());
        }
        return list;
    }

    public List<CallFrame> callstack() {
        return Arrays.asList(this.queue.toArray(new CallFrame[this.queue.size()]));
    }

    public boolean hasAnyAncestor(String fnName, boolean skipHead) {
        Iterator<CallFrame> iter = this.queue.iterator();
        if (skipHead && iter.hasNext()) {
            iter.next();
        }
        while (iter.hasNext()) {
            CallFrame cf = iter.next();
            if (!cf.hasFnName(fnName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNearestAncestor(String fnName, boolean skipHead) {
        Iterator<CallFrame> iter = this.queue.iterator();
        if (skipHead && iter.hasNext()) {
            iter.next();
        }
        if (iter.hasNext()) {
            CallFrame cf = iter.next();
            return cf.hasFnName(fnName);
        }
        return false;
    }

    public String toString() {
        return this.toList().stream().collect(Collectors.joining("\n"));
    }
}

