/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncTinyVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.repackage.io.vavr.collection.IndexedSeq;
import org.repackage.io.vavr.collection.Seq;
import org.repackage.io.vavr.collection.Vector;

public class VncVector
extends VncSequence
implements IVncFunction {
    public static final String TYPE = ":core/vector";
    private static final long serialVersionUID = -1848883965231344442L;
    private final Vector<VncVal> value;

    protected VncVector(VncVal meta) {
        this((Seq<VncVal>)null, meta);
    }

    protected VncVector(Collection<? extends VncVal> vals, VncVal meta) {
        this(vals == null ? null : Vector.ofAll(vals), meta);
    }

    public VncVector(Seq<VncVal> vals, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = vals == null ? Vector.empty() : (vals instanceof Vector ? (Vector<Object>)vals : Vector.ofAll(vals));
    }

    public static VncVector of(VncVal ... mvs) {
        return mvs.length <= 4 ? VncTinyVector.of(mvs) : new VncVector(Vector.of(mvs), null);
    }

    public static VncVector ofList(List<? extends VncVal> list) {
        return list.size() <= 4 ? VncTinyVector.ofArr(list.toArray(new VncVal[0]), null) : new VncVector(list, null);
    }

    public static VncVector ofList(List<? extends VncVal> list, VncVal meta) {
        return list.size() <= 4 ? VncTinyVector.ofArr(list.toArray(new VncVal[0]), meta) : new VncVector(list, meta);
    }

    public static VncVector ofColl(Collection<? extends VncVal> vals) {
        return new VncVector(vals, (VncVal)Constants.Nil);
    }

    public static VncVector ofColl(Collection<? extends VncVal> vals, VncVal meta) {
        return new VncVector(vals, meta);
    }

    public static VncVector ofAll(Iterable<? extends VncVal> iter, VncVal meta) {
        return new VncVector(Vector.ofAll(iter), meta);
    }

    public static VncVector ofAll(Stream<? extends VncVal> stream, VncVal meta) {
        return new VncVector(Vector.ofAll(stream), meta);
    }

    @Override
    public VncVal apply(VncList args) {
        ArityExceptions.assertArity(this, ArityExceptions.FnType.Collection, args, 1, 2);
        if (args.size() == 1) {
            return this.nth(Coerce.toVncLong(args.first()).getValue().intValue());
        }
        return this.nthOrDefault(Coerce.toVncLong(args.first()).getValue().intValue(), args.second());
    }

    @Override
    public VncList getArgLists() {
        return VncList.of(new VncString("(vec index)"), new VncString("(vec index default-val)"));
    }

    @Override
    public VncVector emptyWithMeta() {
        return new VncTinyVector(this.getMeta());
    }

    @Override
    public VncVector withVariadicValues(VncVal ... replaceVals) {
        return replaceVals.length <= 4 ? VncTinyVector.ofArr(replaceVals, this.getMeta()) : new VncVector(Vector.of(replaceVals), this.getMeta());
    }

    @Override
    public VncVector withValues(List<? extends VncVal> replaceVals) {
        return VncVector.ofList(replaceVals, this.getMeta());
    }

    @Override
    public VncVector withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return VncVector.ofList(replaceVals, meta);
    }

    @Override
    public VncVector withMeta(VncVal meta) {
        return new VncVector(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/sequence"), new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : this.value.iterator();
    }

    @Override
    public Stream<VncVal> stream() {
        return this.value.toJavaStream();
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super T v) -> action.accept((VncVal)v));
    }

    @Override
    public VncVector filter(Predicate<? super VncVal> predicate) {
        return new VncVector(this.value.filter(predicate), this.getMeta());
    }

    @Override
    public VncVector map(Function<? super VncVal, ? extends VncVal> mapper) {
        return new VncVector(this.value.map(mapper), this.getMeta());
    }

    @Override
    public List<VncVal> getJavaList() {
        return this.value.asJava();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException(String.format("nth: index %d out of range for a vector of size %d.", idx, this.size()));
        }
        return this.value.get(idx);
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.value.get(idx) : defaultVal;
    }

    @Override
    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.value.head();
    }

    @Override
    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : (VncVal)this.value.last();
    }

    @Override
    public VncVector rest() {
        if (this.value.isEmpty()) {
            return this;
        }
        IndexedSeq rest = this.value.tail();
        return rest.size() <= 4 ? VncTinyVector.ofList(((Vector)rest).asJava(), this.getMeta()) : new VncVector(rest, this.getMeta());
    }

    @Override
    public VncVector butlast() {
        if (this.value.isEmpty()) {
            return this;
        }
        return this.value.size() <= 1 ? this.emptyWithMeta() : new VncVector(this.value.dropRight(1), this.getMeta());
    }

    @Override
    public VncVector drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (n >= this.value.size()) {
            return VncTinyVector.EMPTY;
        }
        return this.value.isEmpty() ? this : new VncVector(this.value.drop(n), this.getMeta());
    }

    @Override
    public VncVector dropWhile(Predicate<? super VncVal> predicate) {
        return new VncVector(this.value.dropWhile(predicate), this.getMeta());
    }

    @Override
    public VncVector dropRight(int n) {
        if (this.value.isEmpty()) {
            return this;
        }
        return n >= this.value.size() ? this.emptyWithMeta() : new VncVector(this.value.dropRight(n), this.getMeta());
    }

    @Override
    public VncVector take(int n) {
        return this.value.isEmpty() ? this : new VncVector(this.value.take(n), this.getMeta());
    }

    @Override
    public VncVector takeWhile(Predicate<? super VncVal> predicate) {
        return new VncVector(this.value.takeWhile(predicate), this.getMeta());
    }

    @Override
    public VncVector takeRight(int n) {
        if (n >= this.value.size()) {
            return this;
        }
        return n <= 0 ? this.emptyWithMeta() : new VncVector(this.value.takeRight(n), this.getMeta());
    }

    @Override
    public VncVector reverse() {
        return new VncVector(this.value.reverse(), this.getMeta());
    }

    @Override
    public VncVector shuffle() {
        return new VncVector(this.value.shuffle(), this.getMeta());
    }

    @Override
    public VncVector distinct() {
        return new VncVector(this.value.distinct(), this.getMeta());
    }

    @Override
    public VncVector slice(int start, int end) {
        return new VncVector(this.value.subSequence(start, Math.min(end, this.value.size())), this.getMeta());
    }

    @Override
    public VncVector slice(int start) {
        return new VncVector(this.value.subSequence(start), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value, this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return this;
    }

    @Override
    public VncVector addAtStart(VncVal val) {
        return new VncVector(this.value.prepend((Object)val), this.getMeta());
    }

    @Override
    public VncVector addAllAtStart(VncSequence list, boolean reverseAdd) {
        VncSequence seq = reverseAdd ? list.reverse() : list;
        return new VncVector(this.value.prependAll((Iterable)seq), this.getMeta());
    }

    @Override
    public VncVector addAtEnd(VncVal val) {
        return new VncVector(this.value.append((Object)val), this.getMeta());
    }

    @Override
    public VncVector addAllAtEnd(VncSequence list) {
        return new VncVector(this.value.appendAll((Iterable)list), this.getMeta());
    }

    @Override
    public VncVector setAt(int idx, VncVal val) {
        return new VncVector(this.value.update(idx, (Object)val), this.getMeta());
    }

    @Override
    public VncVector removeAt(int idx) {
        return new VncVector(this.value.removeAt(idx), this.getMeta());
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.VECTOR;
    }

    @Override
    public Object convertToJavaObject() {
        return this.stream().map((? super T v) -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncVector(o)) {
            int c = Integer.compare(this.size(), ((VncVector)o).size());
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < this.size(); ++ii) {
                c = this.nth(ii).compareTo(((VncVector)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncVector other = (VncVector)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return "[" + Printer.join(this, " ", true) + "]";
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return "[" + Printer.join(this, " ", print_machine_readably) + "]";
    }

    public static VncVector empty() {
        return VncTinyVector.EMPTY;
    }
}

