/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.FastStringWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.Validate;

abstract class BaseTemplate
implements Template {
    protected int line;
    protected int column;
    protected String filename;

    BaseTemplate() {
    }

    public abstract boolean remove(Template var1);

    @Override
    public final String apply(Object context) throws IOException {
        return this.apply(BaseTemplate.wrap(context));
    }

    @Override
    public final void apply(Object context, Writer writer) throws IOException {
        this.apply(BaseTemplate.wrap(context), writer);
    }

    @Override
    public String apply(Context context) throws IOException {
        FastStringWriter writer = new FastStringWriter();
        this.apply(context, (Writer)writer);
        return writer.toString();
    }

    @Override
    public void apply(Context context, Writer writer) throws IOException {
        Validate.notNull((Object)writer, (String)"A writer is required.", (Object[])new Object[0]);
        try {
            this.merge(BaseTemplate.wrap(context), writer);
        }
        catch (HandlebarsException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String message = this.filename + ":" + this.line + ":" + this.column + ": " + ex + "\n";
            message = message + "    " + this.toString();
            HandlebarsException hex = new HandlebarsException(message, ex);
            hex.setStackTrace(ex.getStackTrace());
            throw hex;
        }
    }

    private static Context wrap(Object candidate) {
        if (candidate instanceof Context) {
            return (Context)candidate;
        }
        return Context.newContext(candidate);
    }

    protected abstract void merge(Context var1, Writer var2) throws IOException;

    public String toString() {
        return this.text();
    }

    public BaseTemplate filename(String filename) {
        this.filename = filename;
        return this;
    }

    public BaseTemplate position(int line, int column) {
        this.line = line;
        this.column = column;
        return this;
    }
}

