/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Handlebars;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import org.apache.commons.lang3.Validate;
import org.parboiled.common.Preconditions;

public abstract class TemplateLoader {
    protected static final String DEFAULT_PREFIX = "/";
    public static final String DEFAULT_SUFFIX = ".hbs";
    private String prefix = "/";
    private String suffix = ".hbs";

    public Reader load(URI uri) throws IOException {
        Validate.notNull((Object)uri, (String)"The uri is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)uri.toString(), (String)"The uri is required.", (Object[])new Object[0]);
        String location = this.resolve(this.normalize(uri.toString()));
        Reader reader = this.read(location);
        if (reader == null) {
            throw new FileNotFoundException(location.toString());
        }
        Handlebars.debug("Resource found: %s", location);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadAsString(URI uri) throws IOException {
        BufferedReader reader = new BufferedReader(this.load(uri));
        try {
            int ch;
            StringBuilder buffer = new StringBuilder(4096);
            while ((ch = ((Reader)reader).read()) != -1) {
                buffer.append((char)ch);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public String resolve(String uri) {
        return this.prefix + this.normalize(uri) + this.suffix;
    }

    private String normalize(String uri) {
        if (uri.startsWith(DEFAULT_PREFIX)) {
            return uri.substring(1);
        }
        return uri;
    }

    protected abstract Reader read(String var1) throws IOException;

    public void setPrefix(String prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"A view prefix is required.");
        Preconditions.checkArgument((prefix.length() > 0 ? 1 : 0) != 0, (Object)"A view prefix is required.");
        this.prefix = prefix;
        if (!this.prefix.endsWith(DEFAULT_PREFIX)) {
            this.prefix = this.prefix + DEFAULT_PREFIX;
        }
    }

    public void setSuffix(String suffix) {
        Preconditions.checkNotNull((Object)suffix, (Object)"A view suffix is required.");
        Preconditions.checkArgument((suffix.length() > 0 ? 1 : 0) != 0, (Object)"A view suffix  is required.");
        this.suffix = (String)Preconditions.checkNotNull((Object)suffix, (Object)"The view suffix is required.");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

