/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parboiled.common.Preconditions;

public final class Context {
    private static final Object NULL = new Object();
    private static final Pattern IDX = Pattern.compile("\\[((.)+)\\]");
    private static final Pattern INT = Pattern.compile("\\d+");
    public static final String PARTIALS = Context.class.getName() + "#partials";
    private Context parent;
    private final Object model;
    private Map<String, Object> storage;
    private Context extendedContext;
    private ValueResolver resolver;

    private Context(Object model) {
        if (model instanceof Context) {
            throw new IllegalArgumentException("Invalid model type:" + model.getClass().getName());
        }
        this.model = model;
    }

    private static Context root(Object model) {
        Context root = new Context(model);
        root.extendedContext = new Context(new HashMap());
        root.parent = null;
        root.storage = new HashMap<String, Object>();
        root.storage.put(PARTIALS, new HashMap());
        return root;
    }

    private static Context child(Context parent, Object model) {
        Preconditions.checkNotNull((Object)parent, (Object)"A parent context is required.");
        Context child = new Context(model);
        child.extendedContext = new Context(new HashMap());
        child.parent = parent;
        child.storage = parent.storage;
        return child;
    }

    private void combine(String name, Object model) {
        Preconditions.checkNotNull((Object)name, (Object)"The variable's name is required.");
        Map map = (Map)this.extendedContext.model;
        map.put(name, model);
    }

    private void combine(Map<String, Object> model) {
        Map map = (Map)this.extendedContext.model;
        map.putAll(model);
    }

    public Map<String, Object> storage() {
        return this.storage;
    }

    public Object model() {
        return this.model;
    }

    public Object get(String key) {
        if (".".equals(key) || "this".equals(key)) {
            return this.model;
        }
        if (key.startsWith("../")) {
            return this.parent == null ? null : this.parent.get(key.substring("../".length()));
        }
        String[] path = this.toPath(key);
        Object value = this.get(path);
        if (value == null && (value = this.get(this.extendedContext, key)) == null) {
            value = this.get(this.parent, key);
        }
        return value == NULL ? null : value;
    }

    private Object get(Context external, String key) {
        return external == null ? null : external.get(key);
    }

    private String[] toPath(String key) {
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        int len = tokenizer.countTokens();
        if (len == 1) {
            return new String[]{key.toString()};
        }
        String[] path = new String[len];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            path[i++] = tokenizer.nextToken();
        }
        return path;
    }

    private Object get(String[] path) {
        int start;
        Object current = this.model;
        for (int i = start = path[0].startsWith("this") ? 1 : 0; i < path.length - 1; ++i) {
            if ((current = this.resolve(current, path[i])) != null) continue;
            return null;
        }
        String name = path[path.length - 1];
        Object value = this.resolve(current, name);
        if (value == null && current != this.model) {
            value = NULL;
        }
        return value;
    }

    private Object resolve(Object current, String expression) {
        if (current == null) {
            return null;
        }
        Matcher matcher = IDX.matcher(expression);
        if (matcher.matches()) {
            String idx = matcher.group(1);
            if (INT.matcher(idx).matches()) {
                int pos = Integer.parseInt(idx);
                if (current instanceof List) {
                    return ((List)current).get(pos);
                }
                if (current.getClass().isArray()) {
                    return Array.get(current, pos);
                }
            }
            return this.resolver.resolve(current, idx);
        }
        return this.resolver.resolve(current, expression);
    }

    private void setResolver(ValueResolver resolver) {
        this.resolver = resolver;
        this.extendedContext.resolver = resolver;
    }

    public String toString() {
        return String.valueOf(this.model);
    }

    public static Builder newBuilder(Context parent, Object model) {
        Preconditions.checkNotNull((Object)parent, (Object)"The parent context is required.");
        return new Builder(parent, model);
    }

    public static Builder newBuilder(Object model) {
        return new Builder(model);
    }

    public static Context newContext(Context parent, Object model) {
        return Context.newBuilder(parent, model).build();
    }

    public static Context newContext(Object model) {
        return Context.newBuilder(model).build();
    }

    public static final class Builder {
        private Context context;

        private Builder(Context parent, Object model) {
            this.context = Context.child(parent, model);
        }

        private Builder(Object model) {
            this.context = Context.root(model);
        }

        public Builder combine(String name, Object model) {
            this.context.combine(name, model);
            return this;
        }

        public Builder combine(Map<String, Object> model) {
            this.context.combine(model);
            return this;
        }

        public Builder resolver(ValueResolver ... resolvers) {
            if (resolvers.length == 0) {
                throw new IllegalArgumentException("At least one value-resolver must be present.");
            }
            this.context.setResolver(new CompositeValueResolver(resolvers));
            return this;
        }

        public Context build() {
            if (this.context.resolver == null) {
                if (this.context.parent != null) {
                    this.context.resolver = this.context.parent.resolver;
                } else {
                    this.context.setResolver(new CompositeValueResolver(MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE));
                }
                if (this.context.extendedContext != null) {
                    this.context.extendedContext.resolver = this.context.resolver;
                }
            }
            return this.context;
        }
    }

    private static class CompositeValueResolver
    implements ValueResolver {
        private ValueResolver[] resolvers;

        public CompositeValueResolver(ValueResolver ... resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public Object resolve(Object context, String name) {
            for (ValueResolver resolver : this.resolvers) {
                Object value = resolver.resolve(context, name);
                if (value == UNRESOLVED) continue;
                return value == null ? NULL : value;
            }
            return null;
        }
    }
}

