/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.TypeSafeTemplate;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.Validate;

class ForwardingTemplate
implements Template {
    private final Template template;

    public ForwardingTemplate(Template template) {
        this.template = (Template)Validate.notNull((Object)template, (String)"The template is required.", (Object[])new Object[0]);
    }

    @Override
    public void apply(Object context, Writer writer) throws IOException {
        this.apply(ForwardingTemplate.wrap(context), writer);
    }

    @Override
    public String apply(Object context) throws IOException {
        return this.apply(ForwardingTemplate.wrap(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Context context, Writer writer) throws IOException {
        Context wrappedContext = ForwardingTemplate.wrap(context);
        try {
            this.beforeApply(wrappedContext);
            this.template.apply(wrappedContext, writer);
        }
        finally {
            this.afterApply(wrappedContext);
            if (wrappedContext != context) {
                wrappedContext.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String apply(Context context) throws IOException {
        Context wrappedContext = ForwardingTemplate.wrap(context);
        try {
            this.beforeApply(wrappedContext);
            String string = this.template.apply(wrappedContext);
            return string;
        }
        finally {
            this.afterApply(wrappedContext);
            if (wrappedContext != context) {
                wrappedContext.destroy();
            }
        }
    }

    protected void afterApply(Context context) {
    }

    protected void beforeApply(Context context) {
    }

    @Override
    public String text() {
        return this.template.text();
    }

    @Override
    public String toJavaScript() throws IOException {
        return this.template.toJavaScript();
    }

    @Override
    public <T, S extends TypeSafeTemplate<T>> S as(Class<S> type) {
        return this.template.as(type);
    }

    @Override
    public <T> TypeSafeTemplate<T> as() {
        return this.template.as();
    }

    public String toString() {
        return this.template.toString();
    }

    private static Context wrap(Object candidate) {
        if (candidate instanceof Context) {
            return (Context)candidate;
        }
        return Context.newContext(candidate);
    }
}

