/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;

public class CaffeineTemplateCache
implements TemplateCache {
    private final Cache<TemplateSource, Template> cache;

    public CaffeineTemplateCache(Cache<TemplateSource, Template> cache) {
        this.cache = Objects.requireNonNull(cache, "The cache is required.");
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public void evict(TemplateSource source) {
        this.cache.invalidate((Object)source);
    }

    public Template get(TemplateSource source, Parser parser) {
        return (Template)this.cache.get((Object)source, this.parseTemplate(parser));
    }

    public TemplateCache setReload(boolean reload) {
        return this;
    }

    private Function<? super TemplateSource, ? extends Template> parseTemplate(Parser parser) {
        return source -> {
            try {
                return parser.parse(source);
            }
            catch (IOException ex) {
                throw Handlebars.Utils.propagate((Throwable)ex);
            }
        };
    }
}

