/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg.executor;

import android.os.Messenger;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.luojilab.component.componentlib.log.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.github.jimu.msg.EventListener;
import org.github.jimu.msg.bean.EventBean;
import org.github.jimu.msg.bean.RemoteEventBean;
import org.github.jimu.msg.core.MessageFactory;
import org.github.jimu.msg.executor.IPoster;

public class CrossProcessPoster
implements IPoster {
    @Nullable
    private Messenger remoteMessenger;
    private final List<RemoteEventBean> eventCache = new ArrayList<RemoteEventBean>();

    public void setRemoteMessenger(@Nullable Messenger remoteMessenger) {
        this.remoteMessenger = remoteMessenger;
        this.post2Remote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends RemoteEventBean> void post(@NonNull T event) {
        List<RemoteEventBean> list = this.eventCache;
        synchronized (list) {
            this.eventCache.add(event);
            this.post2Remote();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void post2Remote() {
        if (this.remoteMessenger == null) {
            ILogger.logger.monitor("remoteMessenger is not in order ");
            return;
        }
        ILogger.logger.monitor("post to remote process");
        List<RemoteEventBean> list = this.eventCache;
        synchronized (list) {
            while (!this.eventCache.isEmpty()) {
                RemoteEventBean bean = this.eventCache.remove(0);
                try {
                    this.remoteMessenger.send(MessageFactory.obtainEventMsg(bean));
                }
                catch (RemoteException | NullPointerException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
    }

    @Override
    public <T extends EventBean> void postEvent(@NonNull T event, @NonNull EventListener<T> target) {
        this.post((RemoteEventBean)event);
    }
}

