/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;

public class SignatureHelper {
    public static boolean checkSignature(@Nullable Context context, String key) throws IllegalArgumentException, PackageManager.NameNotFoundException {
        if (context == null || TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("context or key is null");
        }
        Signature expected = new Signature(key);
        boolean result = true;
        PackageManager pm = context.getPackageManager();
        PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 64);
        for (int i = 0; i < packageInfo.signatures.length; ++i) {
            result &= expected.equals((Object)packageInfo.signatures[i]);
        }
        return result;
    }

    @Nullable
    public static String getSignature(Context context) {
        if (context != null) {
            PackageManager pm = context.getPackageManager();
            try {
                PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 64);
                boolean cnt = false;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < packageInfo.signatures.length; ++i) {
                    Signature signature = packageInfo.signatures[i];
                    if (signature == null) continue;
                    if (cnt) {
                        sb.append('/');
                    }
                    sb.append(signature.toCharsString());
                }
                return sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static byte[] getSignatureBytes(Context context) {
        if (context != null) {
            PackageManager pm = context.getPackageManager();
            try {
                PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 64);
                ByteBuffer result = ByteBuffer.allocate(1024);
                for (int i = 0; i < packageInfo.signatures.length; ++i) {
                    int n;
                    Signature signature = packageInfo.signatures[i];
                    if (signature == null) continue;
                    byte[] bytes = signature.toByteArray();
                    int n2 = n = bytes != null ? bytes.length : 0;
                    if (n <= 0) continue;
                    if (n > result.remaining()) {
                        result.flip();
                        ByteBuffer temp = ByteBuffer.allocate(result.capacity() + n * 2);
                        temp.put(result);
                        result = temp;
                    }
                    result.put(bytes);
                }
                result.flip();
                int n = result.limit();
                if (n > 0) {
                    byte[] bytes = new byte[n];
                    result.get(bytes);
                    return bytes;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

