/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.graphics;

import android.graphics.Path;
import com.serenegiant.graphics.PathShape;

public class TriangleShape
extends PathShape {
    public TriangleShape() {
        this(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public TriangleShape(float[] pointes) {
        this(pointes[0], pointes[1], pointes[2], pointes[3], pointes[4], pointes[5]);
    }

    public TriangleShape(float x0, float y0, float x1, float y1, float x2, float y2) {
        super(null, TriangleShape.delta(x0, x1, x2), TriangleShape.delta(y0, y1, y2));
        float minx = TriangleShape.min(x0, x1, x2);
        float miny = TriangleShape.min(y0, y1, y2);
        Path path = new Path();
        path.moveTo(x0 - minx, y0 - miny);
        path.lineTo(x1 - minx, y1 - miny);
        path.lineTo(x2 - minx, y2 - miny);
        path.close();
        this.setPath(path);
    }

    private static final float min(float v0, float v1, float v2) {
        return Math.min(Math.min(v0, v1), v2);
    }

    private static final float max(float v0, float v1, float v2) {
        return Math.max(Math.max(v0, v1), v2);
    }

    private static final float delta(float v0, float v1, float v2) {
        return TriangleShape.max(v0, v1, v2) - TriangleShape.min(v0, v1, v2);
    }
}

