/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.util.Log;

public class LogUtils {
    public static final int DEBUG_LEVEL_OFF = 0;
    public static final int DEBUG_LEVEL_ERROR = 1;
    public static final int DEBUG_LEVEL_WARNING = 2;
    public static final int DEBUG_LEVEL_INFO = 3;
    public static final int DEBUG_LEVEL_DEBUG = 4;
    public static final int DEBUG_LEVEL_VERBOSE = 5;
    private static String TAG = LogUtils.class.getSimpleName();
    private static int LOG_LEVEL = 0;

    public void tag(String tag) {
        TAG = tag != null ? tag : LogUtils.class.getSimpleName();
    }

    public static void logLevel(int level) {
        LOG_LEVEL = level;
    }

    public static int logLevel() {
        return LOG_LEVEL;
    }

    public static void v() {
        if (LOG_LEVEL >= 5) {
            Log.v((String)TAG, (String)LogUtils.getMetaInfo());
        }
    }

    public static void v(String message) {
        if (LOG_LEVEL >= 5) {
            Log.v((String)TAG, (String)(LogUtils.getMetaInfo() + LogUtils.null2str(message)));
        }
    }

    public static void d() {
        if (LOG_LEVEL >= 4) {
            Log.d((String)TAG, (String)LogUtils.getMetaInfo());
        }
    }

    public static void d(String message) {
        if (LOG_LEVEL >= 4) {
            Log.d((String)TAG, (String)(LogUtils.getMetaInfo() + LogUtils.null2str(message)));
        }
    }

    public static void i() {
        if (LOG_LEVEL >= 3) {
            Log.i((String)TAG, (String)LogUtils.getMetaInfo());
        }
    }

    public static void i(String message) {
        if (LOG_LEVEL >= 3) {
            Log.i((String)TAG, (String)(LogUtils.getMetaInfo() + LogUtils.null2str(message)));
        }
    }

    public static void w(String message) {
        if (LOG_LEVEL >= 2) {
            Log.w((String)TAG, (String)(LogUtils.getMetaInfo() + LogUtils.null2str(message)));
        }
    }

    public static void w(String message, Throwable e) {
        if (LOG_LEVEL >= 2) {
            Log.w((String)TAG, (String)(LogUtils.getMetaInfo() + LogUtils.null2str(message)), (Throwable)e);
            LogUtils.printThrowable(e);
            if (e.getCause() != null) {
                LogUtils.printThrowable(e.getCause());
            }
        }
    }

    public static void e(String message) {
        if (LOG_LEVEL >= 1) {
            Log.e((String)TAG, (String)(LogUtils.getMetaInfo() + LogUtils.null2str(message)));
        }
    }

    public static void e(String message, Throwable e) {
        if (LOG_LEVEL >= 1) {
            Log.e((String)TAG, (String)(LogUtils.getMetaInfo() + LogUtils.null2str(message)), (Throwable)e);
            LogUtils.printThrowable(e);
            if (e.getCause() != null) {
                LogUtils.printThrowable(e.getCause());
            }
        }
    }

    public static void e(Throwable e) {
        if (LOG_LEVEL >= 1) {
            LogUtils.printThrowable(e);
            if (e.getCause() != null) {
                LogUtils.printThrowable(e.getCause());
            }
        }
    }

    private static String null2str(String string2) {
        if (string2 == null) {
            return "(null)";
        }
        return string2;
    }

    private static void printThrowable(Throwable e) {
        Log.e((String)TAG, (String)(e.getClass().getName() + ": " + e.getMessage()));
        for (StackTraceElement element : e.getStackTrace()) {
            Log.e((String)TAG, (String)("  at " + LogUtils.getMetaInfo(element)));
        }
    }

    private static String getMetaInfo() {
        StackTraceElement element = Thread.currentThread().getStackTrace()[4];
        return LogUtils.getMetaInfo(element);
    }

    public static String getMetaInfo(StackTraceElement element) {
        String fullClassName = element.getClassName();
        String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String methodName = element.getMethodName();
        int lineNumber = element.getLineNumber();
        String metaInfo = "[" + simpleClassName + "#" + methodName + ":" + lineNumber + "]";
        return metaInfo;
    }
}

