/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.net;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.serenegiant.utils.BuildCheck;
import com.serenegiant.utils.HandlerThreadHandler;
import java.lang.ref.WeakReference;
import java.util.Locale;

public class ConnectivityHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = ConnectivityHelper.class.getSimpleName();
    public static final int NETWORK_TYPE_NON = 0;
    public static final int NETWORK_TYPE_MOBILE = 1;
    public static final int NETWORK_TYPE_WIFI = 2;
    public static final int NETWORK_TYPE_BLUETOOTH = 128;
    public static final int NETWORK_TYPE_ETHERNET = 512;
    private final Object mSync = new Object();
    private final WeakReference<Context> mWeakContext;
    @NonNull
    private final ConnectivityCallback mCallback;
    private Handler mAsyncHandler;
    private ConnectivityManager.OnNetworkActiveListener mOnNetworkActiveListener;
    private ConnectivityManager.NetworkCallback mNetworkCallback;
    private BroadcastReceiver mNetworkChangedReceiver;
    private int mActiveNetworkType = 0;
    private static final String ACTION_GLOBAL_CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public ConnectivityHelper(@NonNull Context context, @NonNull ConnectivityCallback callback) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mCallback = callback;
        this.mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
        this.init();
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void release() {
        this.updateActiveNetwork(0);
        Context context = this.getContext();
        if (context != null) {
            if (BuildCheck.isLollipop()) {
                ConnectivityManager manager = this.requireConnectivityManager();
                if (this.mOnNetworkActiveListener != null) {
                    try {
                        manager.removeDefaultNetworkActiveListener(this.mOnNetworkActiveListener);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                    this.mOnNetworkActiveListener = null;
                }
                if (this.mNetworkCallback != null) {
                    manager.unregisterNetworkCallback(this.mNetworkCallback);
                    this.mNetworkCallback = null;
                }
            }
            if (this.mNetworkChangedReceiver != null) {
                try {
                    context.unregisterReceiver(this.mNetworkChangedReceiver);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mNetworkChangedReceiver = null;
            }
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                try {
                    this.mAsyncHandler.removeCallbacksAndMessages(null);
                    this.mAsyncHandler.getLooper().quit();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mAsyncHandler = null;
            }
        }
    }

    public boolean isValid() {
        try {
            this.requireConnectivityManager();
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    @Nullable
    private Context getContext() {
        Context context = (Context)this.mWeakContext.get();
        if (context == null) {
            throw new IllegalStateException("context is already released");
        }
        return context;
    }

    @NonNull
    private Context requireContext() throws IllegalStateException {
        Context context = (Context)this.mWeakContext.get();
        if (context == null) {
            throw new IllegalStateException("context is already released");
        }
        return context;
    }

    @NonNull
    private ConnectivityManager requireConnectivityManager() throws IllegalStateException {
        Context context = this.requireContext();
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connManager == null) {
            throw new IllegalStateException("failed to get ConnectivityManager");
        }
        return connManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveNetworkType() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mActiveNetworkType;
        }
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private void init() {
        ConnectivityManager manager = this.requireConnectivityManager();
        if (BuildCheck.isLollipop()) {
            this.mOnNetworkActiveListener = new MyOnNetworkActiveListener();
            manager.addDefaultNetworkActiveListener(this.mOnNetworkActiveListener);
            this.mNetworkCallback = new MyNetworkCallback();
            if (BuildCheck.isNougat()) {
                manager.registerDefaultNetworkCallback(this.mNetworkCallback);
            } else if (BuildCheck.isOreo()) {
                manager.registerDefaultNetworkCallback(this.mNetworkCallback, this.mAsyncHandler);
            } else {
                manager.registerNetworkCallback(new NetworkRequest.Builder().build(), this.mNetworkCallback);
            }
        } else {
            this.mNetworkChangedReceiver = new NetworkChangedReceiver(this);
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(ACTION_GLOBAL_CONNECTIVITY_CHANGE);
            this.requireContext().registerReceiver(this.mNetworkChangedReceiver, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnNetworkChanged(int activeNetworkType) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.post(() -> {
                    try {
                        this.mCallback.onNetworkChanged(activeNetworkType);
                    }
                    catch (Exception e) {
                        this.callOnError(e);
                    }
                });
            } else {
                Log.w((String)TAG, (String)"already released?");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnError(Throwable t) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.post(() -> {
                    try {
                        this.mCallback.onError(t);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                });
            } else {
                Log.w((String)TAG, (String)"already released?");
            }
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @TargetApi(value=21)
    private void updateActiveNetwork(Network network) {
        ConnectivityManager manager = this.requireConnectivityManager();
        NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
        NetworkInfo info = manager.getNetworkInfo(network);
        int activeNetworkType = 0;
        if (capabilities != null && info != null) {
            if (ConnectivityHelper.isWifiNetworkReachable(capabilities, info)) {
                activeNetworkType = 2;
            } else if (ConnectivityHelper.isMobileNetworkReachable(capabilities, info)) {
                activeNetworkType = 1;
            } else if (ConnectivityHelper.isBluetoothNetworkReachable(capabilities, info)) {
                activeNetworkType = 128;
            } else if (ConnectivityHelper.isNetworkReachable(capabilities, info)) {
                activeNetworkType = 512;
            }
        }
        this.updateActiveNetwork(activeNetworkType);
    }

    private void updateActiveNetwork(@Nullable NetworkInfo activeNetworkInfo) {
        int type = activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting() ? activeNetworkInfo.getType() : -1;
        int activeNetworkType = 0;
        switch (type) {
            case -1: {
                break;
            }
            case 0: {
                activeNetworkType = 1;
                break;
            }
            case 1: {
                activeNetworkType = 2;
                break;
            }
            case 9: {
                activeNetworkType = 512;
            }
        }
        this.updateActiveNetwork(activeNetworkType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveNetwork(int activeNetworkType) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mActiveNetworkType != activeNetworkType) {
                int prev = this.mActiveNetworkType;
                this.mActiveNetworkType = activeNetworkType;
                this.callOnNetworkChanged(activeNetworkType);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isWifiNetworkReachable(@NonNull Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (BuildCheck.isLollipop()) {
            Network[] allNetworks;
            if (BuildCheck.isMarshmallow()) {
                Network network = manager.getActiveNetwork();
                NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                NetworkInfo info = manager.getNetworkInfo(network);
                return capabilities != null && info != null && ConnectivityHelper.isWifiNetworkReachable(capabilities, info);
            }
            for (Network network : allNetworks = manager.getAllNetworks()) {
                NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                NetworkInfo info = manager.getNetworkInfo(network);
                if (capabilities == null || info == null || !ConnectivityHelper.isWifiNetworkReachable(capabilities, info)) continue;
                return true;
            }
        } else {
            NetworkInfo activeNetworkInfo = manager.getActiveNetworkInfo();
            if (activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting()) {
                int type = activeNetworkInfo.getType();
                return type == 1 || type == 6 || type == 7 || type == 9;
            }
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isMobileNetworkReachable(@NonNull Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (BuildCheck.isLollipop()) {
            Network[] allNetworks;
            if (BuildCheck.isMarshmallow()) {
                Network network = manager.getActiveNetwork();
                NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                NetworkInfo info = manager.getNetworkInfo(network);
                return capabilities != null && info != null && ConnectivityHelper.isMobileNetworkReachable(capabilities, info);
            }
            for (Network network : allNetworks = manager.getAllNetworks()) {
                NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                NetworkInfo info = manager.getNetworkInfo(network);
                if (capabilities == null || info == null || !ConnectivityHelper.isMobileNetworkReachable(capabilities, info)) continue;
                return true;
            }
        } else {
            NetworkInfo activeNetworkInfo = manager.getActiveNetworkInfo();
            if (activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting()) {
                int type = activeNetworkInfo.getType();
                return type == 0;
            }
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isNetworkReachable(@NonNull Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (BuildCheck.isLollipop()) {
            Network[] allNetworks;
            if (BuildCheck.isMarshmallow()) {
                Network network = manager.getActiveNetwork();
                NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                NetworkInfo info = manager.getNetworkInfo(network);
                return capabilities != null && info != null && ConnectivityHelper.isNetworkReachable(capabilities, info);
            }
            for (Network network : allNetworks = manager.getAllNetworks()) {
                NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                NetworkInfo info = manager.getNetworkInfo(network);
                if (capabilities == null || info == null || !ConnectivityHelper.isNetworkReachable(capabilities, info)) continue;
                return true;
            }
            return false;
        }
        NetworkInfo activeNetworkInfo = manager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=21)
    private static boolean isWifiNetworkReachable(@NonNull NetworkCapabilities capabilities, @NonNull NetworkInfo info) {
        boolean isWiFi = BuildCheck.isOreo() ? capabilities.hasTransport(1) || capabilities.hasTransport(3) : capabilities.hasTransport(1) || capabilities.hasTransport(3);
        return isWiFi && ConnectivityHelper.isNetworkReachable(capabilities, info);
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=21)
    private static boolean isMobileNetworkReachable(@NonNull NetworkCapabilities capabilities, @NonNull NetworkInfo info) {
        boolean isMobile = BuildCheck.isOreoMR1() ? capabilities.hasTransport(0) || capabilities.hasTransport(6) : capabilities.hasTransport(0);
        return isMobile && ConnectivityHelper.isNetworkReachable(capabilities, info);
    }

    @TargetApi(value=21)
    private static boolean isBluetoothNetworkReachable(@NonNull NetworkCapabilities capabilities, @NonNull NetworkInfo info) {
        return capabilities.hasTransport(2) && ConnectivityHelper.isNetworkReachable(capabilities, info);
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=21)
    private static boolean isNetworkReachable(@NonNull NetworkCapabilities capabilities, @NonNull NetworkInfo info) {
        boolean isConnectedOrConnecting;
        NetworkInfo.DetailedState state = info.getDetailedState();
        boolean bl = isConnectedOrConnecting = state == NetworkInfo.DetailedState.CONNECTED || state == NetworkInfo.DetailedState.CONNECTING;
        boolean hasCapability = BuildCheck.isPie() ? capabilities.hasCapability(12) && capabilities.hasCapability(16) && (capabilities.hasCapability(21) || capabilities.hasCapability(19)) : (BuildCheck.isMarshmallow() ? capabilities.hasCapability(12) && capabilities.hasCapability(16) : capabilities.hasCapability(12));
        return isConnectedOrConnecting && hasCapability;
    }

    public static String getNetworkTypeString(int networkType) {
        switch (networkType) {
            case 0: {
                return "NON";
            }
            case 1: {
                return "MOBILE";
            }
            case 2: {
                return "WIFI";
            }
            case 128: {
                return "BLUETOOTH";
            }
            case 512: {
                return "ETHERNET";
            }
        }
        return String.format(Locale.US, "UNKNOWN(%d)", networkType);
    }

    @SuppressLint(value={"MissingPermission"})
    private static class NetworkChangedReceiver
    extends BroadcastReceiver {
        private static final String TAG = NetworkChangedReceiver.class.getSimpleName();
        @NonNull
        private final ConnectivityHelper mParent;

        public NetworkChangedReceiver(@NonNull ConnectivityHelper parent) {
            this.mParent = parent;
        }

        public void onReceive(Context context, Intent intent) {
            String action;
            String string2 = action = intent != null ? intent.getAction() : null;
            if (ConnectivityHelper.ACTION_GLOBAL_CONNECTIVITY_CHANGE.equals(action)) {
                this.onReceiveGlobal(context, intent);
            }
        }

        private void onReceiveGlobal(Context context, Intent intent) {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            this.mParent.updateActiveNetwork(manager.getActiveNetworkInfo());
        }
    }

    @TargetApi(value=21)
    private class MyNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private final String TAG = MyNetworkCallback.class.getSimpleName();

        @SuppressLint(value={"MissingPermission"})
        public void onAvailable(Network network) {
            super.onAvailable(network);
            ConnectivityHelper.this.updateActiveNetwork(network);
        }

        @SuppressLint(value={"MissingPermission"})
        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            super.onCapabilitiesChanged(network, networkCapabilities);
            ConnectivityHelper.this.updateActiveNetwork(network);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            super.onLinkPropertiesChanged(network, linkProperties);
        }

        public void onLosing(Network network, int maxMsToLive) {
            super.onLosing(network, maxMsToLive);
        }

        @SuppressLint(value={"MissingPermission"})
        public void onLost(Network network) {
            super.onLost(network);
            ConnectivityHelper.this.updateActiveNetwork(network);
        }

        public void onUnavailable() {
            super.onUnavailable();
            ConnectivityHelper.this.updateActiveNetwork(0);
        }
    }

    @TargetApi(value=21)
    private class MyOnNetworkActiveListener
    implements ConnectivityManager.OnNetworkActiveListener {
        private final String TAG = MyOnNetworkActiveListener.class.getSimpleName();

        public void onNetworkActive() {
        }
    }

    public static interface ConnectivityCallback {
        public void onNetworkChanged(int var1);

        public void onError(Throwable var1);
    }
}

