/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.notification;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Bundle;
import android.widget.RemoteViews;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.serenegiant.notification.ChannelBuilder;
import com.serenegiant.utils.BuildCheck;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class NotificationBuilder
extends NotificationCompat.Builder {
    private static final boolean DEBUG = false;
    private static final String TAG = NotificationBuilder.class.getSimpleName();
    private static final int PRIORITY_UNSPECIFIED = -3;
    @NonNull
    private final Context mContext;
    @NonNull
    private final ChannelBuilder mChannelBuilder;
    @Nullable
    private PendingIntent mContentIntent;
    @Nullable
    private PendingIntent mDeleteIntent;
    @Nullable
    private PendingIntent mFullScreenIntent;
    private boolean mHighPriorityFullScreenIntent;
    private int mPriority = -3;

    public static void showNotification(@NonNull Context context, int notificationId, @NonNull String channelId, String title, String content, @DrawableRes int smallIconId, @Nullable IntentFactory factory) {
        NotificationBuilder.showNotification(context, null, notificationId, channelId, title, content, smallIconId, factory);
    }

    public static void showNotification(@NonNull Context context, @Nullable String tag, int notificationId, @NonNull String channelId, String title, String content, @DrawableRes int smallIconId, final @Nullable IntentFactory factory) {
        NotificationBuilder builder = new NotificationBuilder(context, channelId, smallIconId){

            @Override
            protected PendingIntent createContentIntent() {
                return factory != null ? factory.createContentIntent(this.getContentIntent()) : null;
            }

            @Override
            protected PendingIntent createDeleteIntent() {
                return factory != null ? factory.createDeleteIntent(this.getDeleteIntent()) : super.createDeleteIntent();
            }

            @Override
            @Nullable
            protected PendingIntent createFullScreenIntent() {
                return factory != null ? factory.createFullScreenIntent(this.getFullScreenIntent()) : super.createFullScreenIntent();
            }

            @Override
            public boolean isHighPriorityFullScreenIntent() {
                boolean highPriority = super.isHighPriorityFullScreenIntent();
                return factory != null ? factory.isHighPriorityFullScreenIntent(highPriority) : highPriority;
            }
        };
        builder.setContentTitle(title).setContentText(content);
        if (factory instanceof NotificationBuilderFactory) {
            ((NotificationBuilderFactory)factory).setupBuilder(builder);
        }
        builder.notify(notificationId);
    }

    public NotificationBuilder(@NonNull Context context, @NonNull String channelId, @DrawableRes int smallIconId) {
        super(context, channelId);
        this.mContext = context;
        this.mChannelBuilder = ChannelBuilder.getBuilder(context, channelId);
        this.setSmallIcon(smallIconId);
    }

    @SuppressLint(value={"InlinedApi"})
    public Notification build() {
        if (this.mChannelBuilder.getImportance() == 0) {
            switch (this.mPriority) {
                case -2: {
                    this.mChannelBuilder.setImportance(1);
                    break;
                }
                case -1: {
                    this.mChannelBuilder.setImportance(2);
                    break;
                }
                case 0: {
                    this.mChannelBuilder.setImportance(3);
                    break;
                }
                case 1: {
                    this.mChannelBuilder.setImportance(4);
                    break;
                }
                case 2: {
                    this.mChannelBuilder.setImportance(4);
                    break;
                }
            }
        }
        this.mChannelBuilder.build();
        super.setContentIntent(this.createContentIntent());
        super.setDeleteIntent(this.createDeleteIntent());
        super.setFullScreenIntent(this.createFullScreenIntent(), this.isHighPriorityFullScreenIntent());
        return super.build();
    }

    public NotificationBuilder notify(int notificationId) {
        NotificationBuilder.notify(this.mContext, null, notificationId, this.build());
        return this;
    }

    public NotificationBuilder notify(@Nullable String tag, int notificationId) {
        NotificationBuilder.notify(this.mContext, tag, notificationId, this.build());
        return this;
    }

    public NotificationBuilder notifyForeground(@NonNull Service service, int notificationId) {
        return this.notifyForeground(service, null, notificationId);
    }

    public NotificationBuilder notifyForeground(@NonNull Service service, @Nullable String tag, int notificationId) {
        Notification notification = this.build();
        service.startForeground(notificationId, notification);
        NotificationBuilder.notify((Context)service, tag, notificationId, notification);
        return this;
    }

    @NonNull
    public ChannelBuilder getChannelBuilder() {
        return this.mChannelBuilder;
    }

    public NotificationBuilder setChannelId(@NonNull String channelId) {
        super.setChannelId(channelId);
        this.mChannelBuilder.setId(channelId);
        return this;
    }

    public String getChannelId() {
        return this.mChannelBuilder.getId();
    }

    public NotificationBuilder setChannelName(@Nullable CharSequence channelName) {
        this.mChannelBuilder.setName(channelName);
        return this;
    }

    @Nullable
    public CharSequence getChannelName() {
        return this.mChannelBuilder.getName();
    }

    public NotificationBuilder setImportance(int importance) {
        this.mChannelBuilder.setImportance(importance);
        return this;
    }

    public int getImportance() {
        return this.mChannelBuilder.getImportance();
    }

    public NotificationBuilder setLockscreenVisibility(int lockscreenVisibility) {
        this.mChannelBuilder.setLockscreenVisibility(lockscreenVisibility);
        return this;
    }

    public int getLockscreenVisibility() {
        return this.mChannelBuilder.getLockscreenVisibility();
    }

    public NotificationBuilder setBypassDnd(boolean bypassDnd) {
        this.mChannelBuilder.setBypassDnd(bypassDnd);
        return this;
    }

    public NotificationBuilder setDescription(String description) {
        this.mChannelBuilder.setDescription(description);
        return this;
    }

    public NotificationBuilder setLightColor(int argb) {
        this.mChannelBuilder.setLightColor(argb);
        return this;
    }

    public NotificationBuilder enableLights(boolean lights) {
        this.mChannelBuilder.enableLights(lights);
        return this;
    }

    public NotificationBuilder setShowBadge(boolean showBadge) {
        this.mChannelBuilder.setShowBadge(showBadge);
        return this;
    }

    public NotificationBuilder setVibrationPattern(long[] vibrationPattern) {
        this.mChannelBuilder.setVibrationPattern(vibrationPattern);
        return this;
    }

    public NotificationBuilder enableVibration(boolean vibration) {
        this.mChannelBuilder.enableVibration(vibration);
        return this;
    }

    public NotificationBuilder setSound(Uri sound, AudioAttributes audioAttributes) {
        super.setSound(sound);
        this.mChannelBuilder.setSound(sound, audioAttributes);
        return this;
    }

    public NotificationBuilder setChannelGroup(@Nullable String groupId) {
        this.mChannelBuilder.setGroup(groupId, this.mChannelBuilder.getGroupName());
        return this;
    }

    public NotificationBuilder setChannelGroup(@Nullable String groupId, @Nullable String groupName) {
        this.mChannelBuilder.setGroup(groupId, groupName);
        return this;
    }

    public NotificationBuilder setContentIntent(PendingIntent intent) {
        super.setContentIntent(this.mContentIntent);
        this.mContentIntent = intent;
        return this;
    }

    public PendingIntent getContentIntent() {
        return this.mContentIntent;
    }

    protected abstract PendingIntent createContentIntent();

    public NotificationBuilder setDeleteIntent(PendingIntent intent) {
        super.setDeleteIntent(intent);
        this.mDeleteIntent = intent;
        return this;
    }

    public PendingIntent getDeleteIntent() {
        return this.mDeleteIntent;
    }

    protected PendingIntent createDeleteIntent() {
        return this.mDeleteIntent;
    }

    public NotificationBuilder setWhen(long when) {
        super.setWhen(when);
        return this;
    }

    public NotificationBuilder setShowWhen(boolean show) {
        super.setShowWhen(show);
        return this;
    }

    public NotificationBuilder setUsesChronometer(boolean b) {
        super.setUsesChronometer(b);
        return this;
    }

    public NotificationBuilder setSmallIcon(int icon) {
        super.setSmallIcon(icon);
        return this;
    }

    public NotificationBuilder setSmallIcon(int icon, int level) {
        super.setSmallIcon(icon, level);
        return this;
    }

    public NotificationBuilder setContentTitle(CharSequence title) {
        super.setContentTitle(title);
        return this;
    }

    public NotificationBuilder setContentText(CharSequence text) {
        super.setContentText(text);
        return this;
    }

    public NotificationBuilder setSubText(CharSequence text) {
        super.setSubText(text);
        return this;
    }

    public NotificationBuilder setRemoteInputHistory(CharSequence[] text) {
        super.setRemoteInputHistory(text);
        return this;
    }

    public NotificationBuilder setNumber(int number) {
        super.setNumber(number);
        return this;
    }

    public NotificationBuilder setContentInfo(CharSequence info) {
        super.setContentInfo(info);
        return this;
    }

    public NotificationBuilder setProgress(int max, int progress, boolean indeterminate) {
        super.setProgress(max, progress, indeterminate);
        return this;
    }

    public NotificationBuilder setContent(RemoteViews views) {
        super.setContent(views);
        return this;
    }

    public NotificationBuilder setFullScreenIntent(PendingIntent intent, boolean highPriority) {
        super.setFullScreenIntent(intent, highPriority);
        this.mFullScreenIntent = intent;
        this.mHighPriorityFullScreenIntent = highPriority;
        return this;
    }

    public PendingIntent getFullScreenIntent() {
        return this.mFullScreenIntent;
    }

    public boolean isHighPriorityFullScreenIntent() {
        return this.mHighPriorityFullScreenIntent;
    }

    @Nullable
    protected PendingIntent createFullScreenIntent() {
        return this.mFullScreenIntent;
    }

    public NotificationBuilder setTicker(CharSequence tickerText) {
        super.setTicker(tickerText);
        return this;
    }

    public NotificationBuilder setTicker(CharSequence tickerText, RemoteViews views) {
        super.setTicker(tickerText, views);
        return this;
    }

    public NotificationBuilder setLargeIcon(Bitmap icon) {
        super.setLargeIcon(icon);
        return this;
    }

    public NotificationBuilder setLargeIcon(@DrawableRes int largeIconId) {
        super.setLargeIcon(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)largeIconId));
        return this;
    }

    public NotificationBuilder setSound(Uri sound) {
        super.setSound(sound);
        this.mChannelBuilder.setSound(sound, null);
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public NotificationBuilder setSound(Uri sound, int streamType) {
        super.setSound(sound, streamType);
        AudioAttributes attribute = BuildCheck.isLollipop() ? new AudioAttributes.Builder().setLegacyStreamType(streamType).build() : null;
        this.mChannelBuilder.setSound(sound, attribute);
        return this;
    }

    public NotificationBuilder setVibrate(long[] pattern) {
        super.setVibrate(pattern);
        this.mChannelBuilder.setVibrationPattern(pattern);
        return this;
    }

    public NotificationBuilder setLights(int argb, int onMs, int offMs) {
        super.setLights(argb, onMs, offMs);
        this.mChannelBuilder.setLightColor(argb);
        return this;
    }

    public NotificationBuilder setOngoing(boolean ongoing) {
        super.setOngoing(ongoing);
        return this;
    }

    public NotificationBuilder setColorized(boolean colorize) {
        super.setColorized(colorize);
        return this;
    }

    public NotificationBuilder setOnlyAlertOnce(boolean onlyAlertOnce) {
        super.setOnlyAlertOnce(onlyAlertOnce);
        return this;
    }

    public NotificationBuilder setAutoCancel(boolean autoCancel) {
        super.setAutoCancel(autoCancel);
        return this;
    }

    public NotificationBuilder setLocalOnly(boolean b) {
        super.setLocalOnly(b);
        return this;
    }

    public NotificationBuilder setCategory(String category) {
        super.setCategory(category);
        return this;
    }

    public NotificationBuilder setDefaults(int defaults) {
        super.setDefaults(defaults);
        return this;
    }

    public NotificationBuilder setPriority(int pri) {
        super.setPriority(pri);
        this.mPriority = pri;
        return this;
    }

    public NotificationBuilder addPerson(String uri) {
        super.addPerson(uri);
        return this;
    }

    public NotificationBuilder setGroup(String groupKey) {
        super.setGroup(groupKey);
        return this;
    }

    public NotificationBuilder setGroupSummary(boolean isGroupSummary) {
        super.setGroupSummary(isGroupSummary);
        return this;
    }

    public NotificationBuilder setSortKey(String sortKey) {
        super.setSortKey(sortKey);
        return this;
    }

    public NotificationBuilder addExtras(Bundle extras) {
        super.addExtras(extras);
        return this;
    }

    public NotificationBuilder setExtras(Bundle extras) {
        super.setExtras(extras);
        return this;
    }

    public NotificationBuilder addAction(int icon, CharSequence title, PendingIntent intent) {
        super.addAction(icon, title, intent);
        return this;
    }

    public NotificationBuilder addAction(NotificationCompat.Action action) {
        super.addAction(action);
        return this;
    }

    public NotificationBuilder setStyle(NotificationCompat.Style style) {
        super.setStyle(style);
        return this;
    }

    public NotificationBuilder setColor(int argb) {
        super.setColor(argb);
        return this;
    }

    public NotificationBuilder setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.mChannelBuilder.setLockscreenVisibility(visibility);
        return this;
    }

    public NotificationBuilder setPublicVersion(Notification n) {
        super.setPublicVersion(n);
        return this;
    }

    public NotificationBuilder setCustomContentView(RemoteViews contentView) {
        super.setCustomContentView(contentView);
        return this;
    }

    public NotificationBuilder setCustomBigContentView(RemoteViews contentView) {
        super.setCustomBigContentView(contentView);
        return this;
    }

    public NotificationBuilder setCustomHeadsUpContentView(RemoteViews contentView) {
        super.setCustomHeadsUpContentView(contentView);
        return this;
    }

    public NotificationBuilder setTimeoutAfter(long durationMs) {
        super.setTimeoutAfter(durationMs);
        return this;
    }

    public NotificationBuilder setShortcutId(String shortcutId) {
        super.setShortcutId(shortcutId);
        return this;
    }

    public NotificationBuilder setBadgeIconType(int icon) {
        super.setBadgeIconType(icon);
        return this;
    }

    public NotificationBuilder setGroupAlertBehavior(int groupAlertBehavior) {
        super.setGroupAlertBehavior(groupAlertBehavior);
        return this;
    }

    public NotificationBuilder extend(NotificationCompat.Extender extender) {
        super.extend(extender);
        return this;
    }

    private static void notify(@NonNull Context context, @Nullable String tag, int notificationId, @NonNull Notification notification) {
        NotificationManagerCompat.from((Context)context).notify(tag, notificationId, notification);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BadgeIconType {
    }

    public static class DefaultIntentFactory
    implements NotificationBuilderFactory {
        @Override
        @Nullable
        public PendingIntent createContentIntent(@Nullable PendingIntent intent) {
            return intent;
        }

        @Override
        @Nullable
        public PendingIntent createDeleteIntent(@Nullable PendingIntent intent) {
            return intent;
        }

        @Override
        @Nullable
        public PendingIntent createFullScreenIntent(@Nullable PendingIntent intent) {
            return intent;
        }

        @Override
        public boolean isHighPriorityFullScreenIntent(boolean highPriority) {
            return highPriority;
        }

        @Override
        public void setupBuilder(@NonNull NotificationBuilder builder) {
        }
    }

    public static interface NotificationBuilderFactory
    extends IntentFactory {
        public void setupBuilder(@NonNull NotificationBuilder var1);
    }

    public static interface IntentFactory {
        @Nullable
        public PendingIntent createContentIntent(@Nullable PendingIntent var1);

        @Nullable
        public PendingIntent createDeleteIntent(@Nullable PendingIntent var1);

        @Nullable
        public PendingIntent createFullScreenIntent(@Nullable PendingIntent var1);

        public boolean isHighPriorityFullScreenIntent(boolean var1);
    }
}

