/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.elvishew.xlog.LogConfiguration;
import com.elvishew.xlog.XLog;
import com.elvishew.xlog.flattener.Flattener2;
import com.elvishew.xlog.flattener.PatternFlattener;
import com.elvishew.xlog.printer.AndroidPrinter;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.file.FilePrinter;
import com.elvishew.xlog.printer.file.naming.FileNameGenerator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class XLogWrapper {
    private static final String TAG = "AUSBC";
    private static final String FLATTERER = "{d yyyy-MM-dd HH:mm:ss.SSS} {l}/{t}: {m}";
    private static boolean mHasInit;

    public static void init(Application application, String folderPath) {
        AndroidPrinter androidPrinter = new AndroidPrinter(true);
        LogConfiguration config = new LogConfiguration.Builder().logLevel(Integer.MIN_VALUE).tag(TAG).enableThreadInfo().disableStackTrace().build();
        String path = TextUtils.isEmpty((CharSequence)folderPath) ? application.getExternalFilesDir(null).getPath() : folderPath;
        path = TextUtils.isEmpty((CharSequence)path) ? application.getFilesDir().getPath() : path;
        FilePrinter filePrinter = new FilePrinter.Builder(path).fileNameGenerator((FileNameGenerator)new MyFileNameGenerator((Context)application)).flattener((Flattener2)new MyFlatterer(FLATTERER)).build();
        XLog.init((LogConfiguration)config, (Printer[])new Printer[]{androidPrinter, filePrinter});
        mHasInit = true;
    }

    public static void v(String tag, String msg) {
        if (mHasInit) {
            XLog.v((String)("++++++++Info->" + tag + "###" + msg));
            return;
        }
        Log.v((String)tag, (String)("++++++++Info->###" + msg));
    }

    public static void i(String tag, String msg) {
        if (mHasInit) {
            XLog.i((String)("++++++++Info->" + tag + "###" + msg));
            return;
        }
        Log.i((String)tag, (String)("++++++++Info->###" + msg));
    }

    public static void d(String tag, String msg) {
        if (mHasInit) {
            XLog.d((String)("++++++++debug->" + tag + "###" + msg));
            return;
        }
        Log.d((String)tag, (String)("++++++++debug->###" + msg));
    }

    public static void w(String tag, String msg) {
        if (mHasInit) {
            XLog.w((String)("++++++++warning->" + tag + "###" + msg));
            return;
        }
        Log.w((String)tag, (String)("++++++++warning->###" + msg));
    }

    public static void w(String tag, String msg, Throwable throwable) {
        if (mHasInit) {
            XLog.w((String)("++++++++warning->" + tag + "###" + msg), (Throwable)throwable);
            return;
        }
        Log.w((String)tag, (String)("++++++++warning->###" + msg), (Throwable)throwable);
    }

    public static void w(String tag, Throwable throwable) {
        if (mHasInit) {
            XLog.w((String)("++++++++warning->" + tag), (Throwable)throwable);
            return;
        }
        Log.w((String)tag, (String)"++++++++warning->", (Throwable)throwable);
    }

    public static void e(String tag, String msg) {
        if (mHasInit) {
            XLog.e((String)("++++++++error->" + tag + "###" + msg));
            return;
        }
        Log.e((String)tag, (String)("++++++++error->###" + msg));
    }

    public static void e(String tag, String msg, Throwable throwable) {
        if (mHasInit) {
            XLog.e((String)("++++++++error->" + tag + "###" + msg), (Throwable)throwable);
            return;
        }
        Log.e((String)tag, (String)("++++++++error->###" + msg), (Throwable)throwable);
    }

    static class MyFlatterer
    extends PatternFlattener {
        public MyFlatterer(String pattern) {
            super(pattern);
        }
    }

    static class MyFileNameGenerator
    implements FileNameGenerator {
        private final Context mCtx;
        private final ThreadLocal<SimpleDateFormat> mLocalDateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            @NonNull
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            }
        };

        public MyFileNameGenerator(Context context) {
            this.mCtx = context;
        }

        public boolean isFileNameChangeable() {
            return true;
        }

        public String generateFileName(int logLevel, long timestamp) {
            SimpleDateFormat sdf = this.mLocalDateFormat.get();
            sdf.setTimeZone(TimeZone.getDefault());
            String dateStr = sdf.format(new Date(timestamp));
            return "AUSBC_v" + this.getVerName() + "_" + dateStr + ".txt";
        }

        private String getVerName() {
            String verName = "";
            try {
                verName = this.mCtx.getPackageManager().getPackageInfo((String)this.mCtx.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            return verName;
        }
    }
}

