/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;

public class Size
implements Parcelable {
    public int type;
    public int frame_type;
    public int index;
    public int width;
    public int height;
    public int frameIntervalType;
    public int frameIntervalIndex;
    public int[] intervals;
    public float[] fps;
    private String frameRates;
    public static final Parcelable.Creator<Size> CREATOR = new Parcelable.Creator<Size>(){

        public Size createFromParcel(Parcel source) {
            return new Size(source);
        }

        public Size[] newArray(int size) {
            return new Size[size];
        }
    };

    public Size(int _type, int _frame_type, int _index, int _width, int _height) {
        this.type = _type;
        this.frame_type = _frame_type;
        this.index = _index;
        this.width = _width;
        this.height = _height;
        this.frameIntervalType = -1;
        this.frameIntervalIndex = 0;
        this.intervals = null;
        this.updateFrameRate();
    }

    public Size(int _type, int _frame_type, int _index, int _width, int _height, int _min_intervals, int _max_intervals, int _step) {
        this.type = _type;
        this.frame_type = _frame_type;
        this.index = _index;
        this.width = _width;
        this.height = _height;
        this.frameIntervalType = 0;
        this.frameIntervalIndex = 0;
        this.intervals = new int[3];
        this.intervals[0] = _min_intervals;
        this.intervals[1] = _max_intervals;
        this.intervals[2] = _step;
        this.updateFrameRate();
    }

    public Size(int _type, int _frame_type, int _index, int _width, int _height, int[] _intervals) {
        int n;
        this.type = _type;
        this.frame_type = _frame_type;
        this.index = _index;
        this.width = _width;
        this.height = _height;
        int n2 = n = _intervals != null ? _intervals.length : -1;
        if (n > 0) {
            this.frameIntervalType = n;
            this.intervals = new int[n];
            System.arraycopy(_intervals, 0, this.intervals, 0, n);
        } else {
            this.frameIntervalType = -1;
            this.intervals = null;
        }
        this.frameIntervalIndex = 0;
        this.updateFrameRate();
    }

    public Size(Size other) {
        int n;
        this.type = other.type;
        this.frame_type = other.frame_type;
        this.index = other.index;
        this.width = other.width;
        this.height = other.height;
        this.frameIntervalType = other.frameIntervalType;
        this.frameIntervalIndex = other.frameIntervalIndex;
        int n2 = n = other.intervals != null ? other.intervals.length : -1;
        if (n > 0) {
            this.intervals = new int[n];
            System.arraycopy(other.intervals, 0, this.intervals, 0, n);
        } else {
            this.intervals = null;
        }
        this.updateFrameRate();
    }

    private Size(Parcel source) {
        this.type = source.readInt();
        this.frame_type = source.readInt();
        this.index = source.readInt();
        this.width = source.readInt();
        this.height = source.readInt();
        this.frameIntervalType = source.readInt();
        this.frameIntervalIndex = source.readInt();
        if (this.frameIntervalType >= 0) {
            this.intervals = this.frameIntervalType > 0 ? new int[this.frameIntervalType] : new int[3];
            source.readIntArray(this.intervals);
        } else {
            this.intervals = null;
        }
        this.updateFrameRate();
    }

    public Size set(Size other) {
        if (other != null) {
            int n;
            this.type = other.type;
            this.frame_type = other.frame_type;
            this.index = other.index;
            this.width = other.width;
            this.height = other.height;
            this.frameIntervalType = other.frameIntervalType;
            this.frameIntervalIndex = other.frameIntervalIndex;
            int n2 = n = other.intervals != null ? other.intervals.length : -1;
            if (n > 0) {
                this.intervals = new int[n];
                System.arraycopy(other.intervals, 0, this.intervals, 0, n);
            } else {
                this.intervals = null;
            }
            this.updateFrameRate();
        }
        return this;
    }

    public float getCurrentFrameRate() throws IllegalStateException {
        int n;
        int n2 = n = this.fps != null ? this.fps.length : 0;
        if (this.frameIntervalIndex >= 0 && this.frameIntervalIndex < n) {
            return this.fps[this.frameIntervalIndex];
        }
        throw new IllegalStateException("unknown frame rate or not ready");
    }

    public void setCurrentFrameRate(float frameRate) {
        int index = -1;
        int n = this.fps != null ? this.fps.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!(this.fps[i] <= frameRate)) continue;
            index = i;
            break;
        }
        this.frameIntervalIndex = index;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.type);
        dest.writeInt(this.frame_type);
        dest.writeInt(this.index);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeInt(this.frameIntervalType);
        dest.writeInt(this.frameIntervalIndex);
        if (this.intervals != null) {
            dest.writeIntArray(this.intervals);
        }
    }

    public void updateFrameRate() {
        int n = this.frameIntervalType;
        if (n > 0) {
            this.fps = new float[n];
            for (int i = 0; i < n; ++i) {
                float f = this.fps[i] = 1.0E7f / (float)this.intervals[i];
            }
        } else if (n == 0) {
            try {
                float fps;
                int min = Math.min(this.intervals[0], this.intervals[1]);
                int max = Math.max(this.intervals[0], this.intervals[1]);
                int step = this.intervals[2];
                if (step > 0) {
                    int i;
                    int m = 0;
                    for (i = min; i <= max; i += step) {
                        ++m;
                    }
                    this.fps = new float[m];
                    m = 0;
                    for (i = min; i <= max; i += step) {
                        int n2 = m++;
                        float f = 1.0E7f / (float)i;
                        this.fps[n2] = f;
                        float f2 = f;
                    }
                }
                float max_fps = 1.0E7f / (float)min;
                int m = 0;
                for (fps = 1.0E7f / (float)min; fps <= max_fps; fps += 1.0f) {
                    ++m;
                }
                this.fps = new float[m];
                m = 0;
                for (fps = 1.0E7f / (float)min; fps <= max_fps; fps += 1.0f) {
                    this.fps[m++] = fps;
                }
            }
            catch (Exception e) {
                this.fps = null;
            }
        }
        int m = this.fps != null ? this.fps.length : 0;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < m; ++i) {
            sb.append(String.format(Locale.US, "%4.1f", Float.valueOf(this.fps[i])));
            if (i >= m - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        this.frameRates = sb.toString();
        if (this.frameIntervalIndex > m) {
            this.frameIntervalIndex = 0;
        }
    }

    public String toString() {
        float frame_rate = 0.0f;
        try {
            frame_rate = this.getCurrentFrameRate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format(Locale.US, "Size(%dx%d@%4.1f,type:%d,frame:%d,index:%d,%s)", this.width, this.height, Float.valueOf(frame_rate), this.type, this.frame_type, this.index, this.frameRates);
    }
}

