/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.render.internal;

import android.content.Context;
import android.opengl.GLES20;
import android.util.Log;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.MediaUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u0000 32\u00020\u0001:\u00013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0014J\u0006\u0010\u0019\u001a\u00020\u0007J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0004J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0016J\b\u0010#\u001a\u00020\u0007H\u0014J\b\u0010$\u001a\u00020\u0007H$J\u0006\u0010%\u001a\u00020\u0007J\u0006\u0010&\u001a\u00020\u0007J\b\u0010'\u001a\u00020\u0007H$J\b\u0010(\u001a\u00020\u0017H\u0014J\u0006\u0010)\u001a\u00020\u0017J\b\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u001cH\u0002J\u0006\u0010/\u001a\u00020\u0017J\u0018\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jiangdg/ausbc/render/internal/AbstractRender;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mContext", "mFragmentShader", "", "mHeight", "mMVPMatrixHandle", "mPositionLocation", "mProgram", "getMProgram", "()I", "setMProgram", "(I)V", "mStMatrixHandle", "mTextureCoordLocation", "mTriangleVertices", "Ljava/nio/FloatBuffer;", "mVertexShader", "mWidth", "beforeDraw", "", "clear", "createOESTexture", "createProgram", "vertexSource", "", "fragmentSource", "createTexture", "textures", "", "drawFrame", "textureId", "getBindTextureType", "getFragmentSourceId", "getRenderHeight", "getRenderWidth", "getVertexSourceId", "init", "initGLES", "isGLESStatusError", "", "loadShader", "shaderType", "source", "releaseGLES", "setSize", "width", "height", "Companion", "libausbc_release"})
public abstract class AbstractRender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mFragmentShader;
    private int mVertexShader;
    private int mProgram;
    @Nullable
    private Context mContext;
    private int mWidth;
    private int mHeight;
    private int mPositionLocation;
    private int mTextureCoordLocation;
    private int mStMatrixHandle;
    private int mMVPMatrixHandle;
    @NotNull
    private FloatBuffer mTriangleVertices;
    @NotNull
    private static final String TAG = "AbstractRender";
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 20;
    private static final int TRIANGLE_VERTICES_DATA_POS_OFFSET = 0;
    private static final int TRIANGLE_VERTICES_DATA_UV_OFFSET = 3;
    @NotNull
    private static final float[] mTriangleVerticesData;

    public AbstractRender(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(mTriangleVerticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)floatBuffer, (String)"allocateDirect(\n        mTriangleVerticesData.size * FLOAT_SIZE_BYTES\n    ).order(ByteOrder.nativeOrder()).asFloatBuffer()");
        this.mTriangleVertices = floatBuffer;
        this.mContext = context;
        this.mTriangleVertices.put(mTriangleVerticesData).position(0);
    }

    protected final int getMProgram() {
        return this.mProgram;
    }

    protected final void setMProgram(int n) {
        this.mProgram = n;
    }

    public void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
    }

    public int drawFrame(int textureId) {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.mProgram);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.getBindTextureType(), (int)textureId);
        this.mTriangleVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.mPositionLocation, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.mTriangleVertices);
        GLES20.glEnableVertexAttribArray((int)this.mPositionLocation);
        this.mTriangleVertices.position(3);
        GLES20.glVertexAttribPointer((int)this.mTextureCoordLocation, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.mTriangleVertices);
        GLES20.glEnableVertexAttribArray((int)this.mTextureCoordLocation);
        this.beforeDraw();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)this.getBindTextureType(), (int)0);
        return textureId;
    }

    protected void beforeDraw() {
    }

    protected void init() {
    }

    protected void clear() {
    }

    protected int getBindTextureType() {
        return 3553;
    }

    protected abstract int getVertexSourceId();

    protected abstract int getFragmentSourceId();

    public final void initGLES() {
        Context context = this.mContext;
        Intrinsics.checkNotNull((Object)context);
        String vertexShaderSource = MediaUtils.INSTANCE.readRawTextFile(context, this.getVertexSourceId());
        Context context2 = this.mContext;
        Intrinsics.checkNotNull((Object)context2);
        String fragmentShaderSource = MediaUtils.INSTANCE.readRawTextFile(context2, this.getFragmentSourceId());
        this.mProgram = this.createProgram(vertexShaderSource, fragmentShaderSource);
        if (this.mProgram == 0) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"create program failed, err = ", (Object)GLES20.glGetError()));
            return;
        }
        this.mPositionLocation = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
        this.mTextureCoordLocation = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTextureCoordinate");
        if (this.isGLESStatusError()) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"create external texture failed, err = ", (Object)GLES20.glGetError()));
            return;
        }
        this.init();
        Logger.INSTANCE.i(TAG, "init surface texture render success!");
    }

    public final void releaseGLES() {
        if (this.mVertexShader != 0) {
            GLES20.glDeleteShader((int)this.mVertexShader);
        }
        if (this.mFragmentShader != 0) {
            GLES20.glDeleteShader((int)this.mFragmentShader);
        }
        if (this.mProgram != 0) {
            GLES20.glDeleteProgram((int)this.mProgram);
        }
        this.clear();
        Logger.INSTANCE.i(TAG, "release surface texture render success!");
    }

    public final int getRenderWidth() {
        return this.mWidth;
    }

    public final int getRenderHeight() {
        return this.mHeight;
    }

    private final int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.e((String)TAG, (String)("Could not compile shader, info = " + GLES20.glGetShaderInfoLog((int)shader) + ", T = " + Thread.currentThread().getName()));
            GLES20.glDeleteShader((int)shader);
            return 0;
        }
        return shader;
    }

    private final int createProgram(String vertexSource, String fragmentSource) {
        this.mVertexShader = this.loadShader(35633, vertexSource);
        if (this.mVertexShader == 0) {
            Logger.INSTANCE.i(TAG, "vertexSource err = " + GLES20.glGetError() + ": \n " + vertexSource);
            return 0;
        }
        this.mFragmentShader = this.loadShader(35632, fragmentSource);
        if (this.mFragmentShader == 0) {
            Logger.INSTANCE.i(TAG, "fragmentSource err = " + GLES20.glGetError() + ": \n " + fragmentSource);
            return 0;
        }
        int program = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)program, (int)this.mVertexShader);
        GLES20.glAttachShader((int)program, (int)this.mFragmentShader);
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            Logger.INSTANCE.e(TAG, "create program failed.");
            GLES20.glDeleteProgram((int)program);
            return 0;
        }
        return program;
    }

    private final boolean isGLESStatusError() {
        return GLES20.glGetError() != 0;
    }

    protected final void createTexture(@NotNull int[] textures) {
        Intrinsics.checkNotNullParameter((Object)textures, (String)"textures");
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"create texture, id = ", (Object)textures[0]));
    }

    public final int createOESTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)36197, (int)textures[0]);
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"create external texture, id = ", (Object)textures[0]));
        return textures[0];
    }

    static {
        float[] fArray = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        mTriangleVerticesData = fArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jiangdg/ausbc/render/internal/AbstractRender$Companion;", "", "()V", "FLOAT_SIZE_BYTES", "", "TAG", "", "TRIANGLE_VERTICES_DATA_POS_OFFSET", "TRIANGLE_VERTICES_DATA_STRIDE_BYTES", "TRIANGLE_VERTICES_DATA_UV_OFFSET", "mTriangleVerticesData", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

